package com.bcxin.backend.tasks.approval;

import com.bcxin.backend.domain.approval.services.BjApprovalDataPushService;
import com.bcxin.backend.tasks.TaskAbstract;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

@Component
@ConditionalOnProperty(prefix = "myapps.bj-approval-data-push",name = "enable",havingValue = "true")
public class ApprovalDataPushTask extends TaskAbstract {
    private final BjApprovalDataPushService approvalDataPushService;

    public ApprovalDataPushTask(BjApprovalDataPushService approvalDataPushService) {
        this.approvalDataPushService = approvalDataPushService;
    }

    @Override
    protected void runCore() throws Exception {
        /**推送过去2天的审批数据。
         * 外网数据每半个小时摆渡进内网，也可能会出现延迟的情况，比如下午2点开始摆渡，lastmodified时间是下午1点45。但是摆渡进内网的时候已经是下午6点。
         * 如果只推送过去1天，可能出现在推送之前进行摆渡，但是在推送之后才摆渡进来。但是lastmodified还是推送之前的时间，（特殊情况）
         * 第二天继续推送的时候，会漏掉这些数据。
         * 依赖摆渡
         */
        Date startDate = Date.from(Instant.now().minus(2, ChronoUnit.DAYS));
        logger.info("推送北京审批数据开始:{}",new Date());
        this.approvalDataPushService.pushApprovalDataFromDate(startDate);
        logger.info("推送北京审批数据结束:{}",new Date());
    }

    @Override
    public String getTaskName() {
        return "push.bj.approval.data.task.daily";
    }
}
