package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.FormTableSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
public class FormMetaJobTask extends TaskAbstract {
    private final static Logger logger = LoggerFactory.getLogger(FormMetaJobTask.class);
    private final FormTableSyncService formTableSyncService;
    private final DataSyncQueueRepository dataSyncQueueRepository;

    public FormMetaJobTask(FormTableSyncService formTableSyncService,
                           DataSyncQueueRepository dataSyncQueueRepository) {
        this.formTableSyncService = formTableSyncService;
        this.dataSyncQueueRepository = dataSyncQueueRepository;
    }

    @Override
    protected void runCore() {
        formTableSyncService.dispatch();
    }

    @Override
    public String getTaskName() {
        return "sync.form.meta";
    }

    @Override
    protected boolean beforeRun() {
        int pendingCount = dataSyncQueueRepository.getPendingCount();

        return pendingCount < 5 * 1000;
    }

    @Override
    protected void afterRun(boolean isAllowedRun) {
        if (!isAllowedRun) {
            logger.error("待处理队列已满, 数据同步操作将在任务处理完成之后，继续执行 ");
        }
    }
}
