package com.bcxin.backend.documentSignatrures.impls;

import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.Random;

@Component
@Qualifier("test")
public class DocumentSignatureProvider_Test extends DocumentSignatureProviderAbstract {
    private static final Logger logger = LoggerFactory.getLogger(DocumentSignatureProvider_Test.class);

    protected DocumentSignatureProvider_Test(SignatureConfigProperty configProperty,
                                             SignatureQueuesDocumentRepository signatureQueuesDocumentRepository,
                                             @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate) {
        super(configProperty, signatureQueuesDocumentRepository, jdbcTemplate);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected boolean activateXMPDocumentQuicklyExCGI(String stamp_xy) throws Exception {
        boolean success = false;

        if ((new Random()).nextBoolean()) {
            success = true;
        }

        logger.error("执行文书签章签章操作:{};success={}", stamp_xy, success);

        return success;
    }
}