package com.bcxin.backend.certificateSignatures.impls.values.pushCertificates;

import com.bcxin.saas.core.ValueType;
import lombok.Getter;
import lombok.Setter;

@Getter
public class CertificateCallBackValueType extends ValueType {
    private final CertificateCallBackStatus status;
    private final String queueId;
    private final String certificateNo;
    private final String code;
    private final String message;

    /**
     * 01是资格证
     * 15是文书
     */
    private final String type;

    /**
     * 数据载体，比如: 北京的file文件
     */
    private final Object dataCarrier;

    private final boolean batchContent;

    @Setter
    private String response;

    /**
     * 满足符合要求的数据
     * @param valueType
     * @return
     */
    public boolean match(CertificateValueType valueType) {
        if (valueType == CertificateValueType.Certificate) {
            return "01".equalsIgnoreCase(this.getType());
        } else if (valueType == CertificateValueType.DocumentCertificate) {
            return "15".equalsIgnoreCase(this.getType());
        }

        return false;
    }

    public CertificateCallBackValueType(
            CertificateCallBackStatus status,
            String queueId, String certificateNo, String code, String type,
            Object dataCarrier,
            boolean batchContent,
            String msg) {
        this.queueId = queueId;
        this.certificateNo = certificateNo;
        this.code = code;
        this.type = type;
        this.dataCarrier = dataCarrier;
        this.status = status;
        this.batchContent = batchContent;

        this.message = batchContent ? String.format("%s:Batch", msg) : msg;
    }

    /**
     * @param queueId
     * @param certificateNo
     * @param code          jt_code
     * @param type
     * @param message
     * @return
     */
    public static CertificateCallBackValueType create(
            CertificateCallBackStatus status,
            String queueId, String certificateNo, String code, String type,
            Object dataCarrier,
            boolean batchContent,
            String message) {
        return new CertificateCallBackValueType(status, queueId, certificateNo, code, type, dataCarrier, batchContent, message);
    }

    public static CertificateCallBackValueType error(
            CertificateCallBackStatus status, Object dataCarrier,
            boolean batchContent,
            String message) {
        return create(status, null, null, "", null, dataCarrier,batchContent, message);
    }

    public void assignResponse(String response) {
        this.setResponse(response);
    }

    public enum CertificateCallBackStatus {
        OK,
        Error,
        Exception
    }

    public enum CertificateValueType {
        Certificate,
        DocumentCertificate
    }
}
