package com.bcxin.backend.certificateSignatures.impls;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.certificateSignatures.CertificateConfigProperty;
import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
@Qualifier("beijing")
public class CertificateSignatureProvider_Beijing extends CertificateSignatureProviderAbstract
        implements CertificateSignatureProvider {
    private static final Logger logger = LoggerFactory.getLogger(CertificateSignatureProvider_Beijing.class);

    public CertificateSignatureProvider_Beijing(CertificateConfigProperty configProperty,
                                                SignatureQueuesRepository signatureQueuesRepository,
                                                @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate,
                                                ConvertServiceImpl convertService) {
        super(configProperty, signatureQueuesRepository, jdbcTemplate, convertService);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    /**
     * 执行电子签章操作
     * @return
     */
    @Override
    protected boolean activateXMPSignQuicklyExCGI() {
        String cgiApi = configProperty.getCgiApi();
        StringBuilder sb = new StringBuilder();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean shouldPrintLog =true;
        try {
            JSONObject json = new JSONObject();

            json.put("service", "wss://127.0.0.1:8800");
            json.put("sn", "2171101001009256");
            json.put("pin", "88888888");
            /**
             * ?这边的/data/share/in 与上一步的temp=>复制到in的关联关系是什么
             */
            json.put("in", "/data/share/in");
            json.put("out", "/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", 405);
            pos.put("centerY", 312);
            pos.put("page", 1);
            arr.add(pos);
            json.put("signOnPos", arr);

            String body = json.toJSONString();
            sb.append(String.format("开始执行请求;cgiApi=%s;body=%s",cgiApi,body));
            String ret = HttpUtil.post(cgiApi, body);
            sb.append(String.format("响应内容=%s;",ret));
            if (StringUtils.isEmpty(ret)) {
                makeHealth(false);
                sb.append("1.返回...【【签章系统发生异常---->需要进行等待操作】】");
                return false;
            }else {
                makeHealth(true);
            }

            sb.append("执行转换操作");
            JSONObject result = JSON.parseObject(ret.replace("#", ""));
            sb.append(String.format("result执行完毕;=%s;",result));
            String code = null;
            if(result!= null) {
                code = String.valueOf(result.get("code"));
            }

            sb.append(String.format("得到的code=%s;",code));
            if ("1".equalsIgnoreCase(code)) {
                sb.append("2.成功");
                return true;
            }else {
                shouldPrintLog = false;
                getLogger().error("电子签章获取到的结果为false:ret={};result={};code={}", ret, result, code);
            }

            sb.append("3.返回false;");
            return false;
        } catch (Exception e) {
            stopWatch.stop();
            getLogger().error("====> 电子签章定时任务开始.activateXMPSignQuicklyExCGI message(cgiApi={}):跟踪:{};耗时{}秒", cgiApi,
                    sb,
                    stopWatch.getTotalTimeSeconds(), e);
        }
        finally {
            if (shouldPrintLog) {
                getLogger().error("====> 2.activateXMPSignQuicklyExCGI.跟踪签章执行情况:{}", sb);
            }
        }

        return false;
    }
}
