/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils.ftp;

import com.bcxin.backend.domain.configs.FileModeConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnection {
    private static final Logger log = LoggerFactory.getLogger(FtpConnection.class);
    private FTPClient ftp = new FTPClient();
    private boolean is_connected = false;

    public FtpConnection() {
        this.ftp.setDefaultTimeout(FileModeConfig.defaultTimeoutSecond * 1000);
        this.ftp.setConnectTimeout(FileModeConfig.connectTimeoutSecond * 1000);
        this.ftp.setDataTimeout(FileModeConfig.dataTimeoutSecond * 1000);
        try {
            this.initConnect(FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initConnect(String host, int port, String user, String password) throws IOException {
        try {
            if (!this.ftp.isConnected()) {
                this.ftp.connect(host, port);
            }
        }
        catch (UnknownHostException ex) {
            throw new IOException("Can't find FTP server '" + host + "'");
        }
        this.ftp.enterLocalPassiveMode();
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.disconnect();
            throw new IOException("Can't connect to server '" + host + "'");
        }
        if (!this.ftp.login(user, password)) {
            this.is_connected = false;
            this.disconnect();
            throw new IOException("Can't login to server '" + host + "'");
        }
        this.is_connected = true;
    }

    public boolean upload(String path, String ftpFileName, File localFile) throws IOException {
        boolean is = false;
        if (!localFile.exists()) {
            throw new IOException("Can't upload '" + localFile.getAbsolutePath() + "'. This file doesn't exist.");
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(path);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile));){
            String filePath = path + "/" + ftpFileName;
            filePath = filePath.replace("\\", "/");
            this.ftp.setFileType(2);
            is = this.ftp.storeFile(filePath, (InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }

    public boolean uploadBase64(String path, String ftpFileName, String base64Content) throws IOException {
        boolean is = false;
        if (base64Content == null || base64Content.isEmpty()) {
            throw new IOException("Can't upload. The base64 content is empty.");
        }
        FtpConnection.conv(path, ftpFileName);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(path);
        byte[] decodedBytes = base64Content.getBytes();
        try (ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);){
            String filePath = path + "/" + ftpFileName;
            filePath = filePath.replace("\\", "/");
            this.ftp.setFileType(2);
            is = this.ftp.storeFile(filePath, (InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }

    private static void conv(String path, String ftpFileName) {
        Path sourcePath = Paths.get(path + ftpFileName, new String[0]);
        if (sourcePath.getParent() != null) {
            path = sourcePath.getParent().toAbsolutePath().toString();
        }
        ftpFileName = sourcePath.getFileName().toString();
    }

    public boolean moveAndReplaceFile(String pathA, String pathB, String fileName, String jsonContent) throws IOException {
        boolean success = false;
        if (jsonContent == null || jsonContent.isEmpty()) {
            throw new IOException("Can't replace file content. The JSON content is empty.");
        }
        pathA = new String(pathA.getBytes("GBK"), "iso-8859-1");
        pathB = new String(pathB.getBytes("GBK"), "iso-8859-1");
        fileName = new String(fileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(pathA);
        String sourceFilePath = pathA + "/" + fileName;
        sourceFilePath = sourceFilePath.replace("\\", "/");
        if (!this.fileExists(sourceFilePath)) {
            throw new IOException("Source file does not exist: " + sourceFilePath);
        }
        this.setWorkingDirectory(pathB);
        String targetFilePath = pathB + "/" + fileName;
        targetFilePath = targetFilePath.replace("\\", "/");
        success = this.ftp.rename(sourceFilePath, targetFilePath);
        if (!success) {
            throw new IOException("Failed to move file from " + sourceFilePath + " to " + targetFilePath);
        }
        byte[] jsonBytes = jsonContent.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(jsonBytes);){
            this.ftp.setFileType(2);
            success = this.ftp.storeFile(targetFilePath, (InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed to replace file content: " + e.getMessage());
        }
        return success;
    }

    private boolean fileExists(String filePath) throws IOException {
        FTPFile[] files;
        String parentDir = new File(filePath).getParent();
        String fileName = new File(filePath).getName();
        for (FTPFile file : files = this.ftp.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean download(String path, String ftpFileName, File localFile) throws IOException {
        boolean is = false;
        if (localFile.exists()) {
            throw new IOException("Can't download '" + localFile.getAbsolutePath() + "'. This file already exists.");
        }
        FtpConnection.conv(path, ftpFileName);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(path);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
            String filePath = path + "/" + ftpFileName;
            filePath = filePath.replace("\\", "/");
            this.ftp.setFileType(2);
            is = this.ftp.retrieveFile(filePath, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }

    /*
     * Exception decompiling
     */
    public String downloadAsBase64(String path, String ftpFileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFileContent(String path, String ftpFileName) throws IOException {
        FtpConnection.conv(path, ftpFileName);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(path);
        StringBuilder content = new StringBuilder();
        ftpFileName = ftpFileName.startsWith("/") ? ftpFileName : "/" + ftpFileName;
        try (BufferedInputStream in = new BufferedInputStream(this.ftp.retrieveFileStream(path + ftpFileName));){
            int length;
            if (in == null) {
                String string = "";
                return string;
            }
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                content.append(new String(buffer, 0, length, "UTF-8"));
            }
            this.ftp.completePendingCommand();
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean delectFile(String path, String filename) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        this.setWorkingDirectory(path);
        return this.ftp.deleteFile(filename);
    }

    public List<String> fileNames(String path, String keywork) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
        }
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a001<=======");
        this.setWorkingDirectory(path);
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a002<=======");
        ArrayList<String> recentFiles = new ArrayList<String>();
        FTPFile[] files = this.ftp.listFiles();
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a003<=======");
        long currentTime = System.currentTimeMillis();
        long fiveMinutesAgo = currentTime - 300000L;
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u6570\u91cf\uff1a" + files.length + "<=======");
        for (FTPFile file : files) {
            Long fileTime = file.getTimestamp().getTimeInMillis() + (long)file.getTimestamp().getTimeZone().getOffset(0L);
            if (!file.isFile() || fileTime < fiveMinutesAgo || StringUtils.isNotEmpty((CharSequence)keywork) && !file.getName().startsWith(keywork)) continue;
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u6709\u6548\u6587\u4ef6\u540d\uff1a" + file.getName() + "<=======");
            recentFiles.add(file.getName());
        }
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6570\u91cf\uff1a" + recentFiles.size() + "<=======");
        return recentFiles;
    }

    public void disconnect() throws IOException {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
                this.is_connected = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean setWorkingDirectory(String dir) {
        if (!this.is_connected) {
            return false;
        }
        try {
            if (this.createDirecroty(dir)) {
                return this.ftp.changeWorkingDirectory(dir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    private boolean createDirecroty(String remote) throws IOException {
        boolean success;
        block3: {
            if (StringUtils.isEmpty((CharSequence)remote)) {
                return false;
            }
            success = true;
            String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
            if (directory.equalsIgnoreCase("/") || this.ftp.changeWorkingDirectory(new String(directory))) break block3;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            do {
                String subDirectory;
                if (this.ftp.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end)))) continue;
                if (this.ftp.makeDirectory(subDirectory)) {
                    this.ftp.changeWorkingDirectory(subDirectory);
                    continue;
                }
                log.error("mack directory error :/" + subDirectory);
                return false;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }
}

