/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.configs;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class ScreenDataSourceConfig {
    @Bean
    @ConfigurationProperties(prefix="spring.datasource.screen")
    public DataSourceProperties screenDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Qualifier(value="primaryDataSource")
    public DataSource primaryDataSource() {
        DataSource ds = this.screenDataSourceProperties().initializeDataSourceBuilder().build();
        return ds;
    }

    @Bean
    @Qualifier(value="primaryJdbcTemplate")
    public JdbcTemplate primaryJdbcTemplate(@Qualifier(value="primaryDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }
}

