/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils.ftp;

import com.bcxin.backend.domain.configs.FileModeConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnection {
    private static final Logger log = LoggerFactory.getLogger(FtpConnection.class);
    private FTPClient ftp = new FTPClient();
    private boolean is_connected = false;

    public FtpConnection() {
        this.ftp.setDefaultTimeout(FileModeConfig.defaultTimeoutSecond * 1000);
        this.ftp.setConnectTimeout(FileModeConfig.connectTimeoutSecond * 1000);
        this.ftp.setDataTimeout(FileModeConfig.dataTimeoutSecond * 1000);
        try {
            this.initConnect(FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initConnect(String host, int port, String user, String password) throws IOException {
        try {
            if (!this.ftp.isConnected()) {
                this.ftp.connect(host, port);
            }
        }
        catch (UnknownHostException ex) {
            throw new IOException("Can't find FTP server '" + host + "'");
        }
        this.ftp.enterLocalPassiveMode();
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.disconnect();
            throw new IOException("Can't connect to server '" + host + "'");
        }
        if (!this.ftp.login(user, password)) {
            this.is_connected = false;
            this.disconnect();
            throw new IOException("Can't login to server '" + host + "'");
        }
        this.is_connected = true;
    }

    public boolean upload(String path, String ftpFileName, File localFile) throws IOException {
        boolean is = false;
        if (!localFile.exists()) {
            throw new IOException("Can't upload '" + localFile.getAbsolutePath() + "'. This file doesn't exist.");
        }
        path = new String(path.getBytes("GBK"), "iso-8859-1");
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        this.setWorkingDirectory(path);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile));){
            String filePath = path + "/" + ftpFileName;
            filePath = filePath.replace("\\", "/");
            this.ftp.setFileType(2);
            is = this.ftp.storeFile(filePath, (InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }

    public void disconnect() throws IOException {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
                this.is_connected = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean setWorkingDirectory(String dir) {
        if (!this.is_connected) {
            return false;
        }
        try {
            if (this.createDirecroty(dir)) {
                return this.ftp.changeWorkingDirectory(dir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    private boolean createDirecroty(String remote) throws IOException {
        boolean success;
        block2: {
            success = true;
            String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
            if (directory.equalsIgnoreCase("/") || this.ftp.changeWorkingDirectory(new String(directory))) break block2;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            do {
                String subDirectory;
                if (this.ftp.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end)))) continue;
                if (this.ftp.makeDirectory(subDirectory)) {
                    this.ftp.changeWorkingDirectory(subDirectory);
                    continue;
                }
                log.error("mack directory error :/" + subDirectory);
                return false;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }
}

