/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.services.impls;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.backend.domain.services.ConvertService;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import com.bcxin.backend.domain.utils.PDFUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConvertServiceImpl
implements ConvertService {
    private static final Logger log = LoggerFactory.getLogger(ConvertServiceImpl.class);
    @Value(value="${myapps.storage.root}")
    String rootPath;

    @Override
    public String execConvertHtmltopdfForTemp(SharedConvertDto convertDto) throws IOException {
        String pdfPath;
        Long a = System.currentTimeMillis();
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl()) || ObjectUtil.isEmpty((Object)convertDto.getFormData())) {
            return null;
        }
        JSONObject data = JSONObject.fromObject((Object)convertDto.getFormData());
        String string = pdfPath = ObjectUtil.isEmpty((Object)data.get("unSignaturePDF")) ? "" : data.get("unSignaturePDF") + "";
        if (StringUtils.isEmpty((CharSequence)pdfPath)) {
            return null;
        }
        String pdfFilePath = this.rootPath + pdfPath;
        System.out.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aexecConvertHtmltopdfForTemp.pdfFilePath:" + pdfFilePath);
        File pdfFile = new File(pdfFilePath);
        if (!pdfFile.getParentFile().exists()) {
            pdfFile.getParentFile().mkdirs();
        }
        PDFUtils.generatePdfByOpenhtmltopdf(convertDto.getTempUrl(), pdfFilePath, convertDto.getFormData());
        pdfFile = new File(pdfFilePath);
        if (pdfFile.length() == 0L) {
            pdfFile.delete();
            return null;
        }
        String newPath = pdfFilePath.replace(".temp", ".pdf");
        System.out.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aexecConvertHtmltopdfForTemp.newPath:" + newPath);
        File newFile = new File(newPath);
        boolean flag = pdfFile.renameTo(newFile);
        if (!flag) {
            pdfFile.delete();
            return null;
        }
        log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.execConvertHtmltopdfForTemp\uff1aTime\uff1a" + (System.currentTimeMillis() - a));
        return newPath;
    }

    public static void main(String[] args) throws IOException {
        SharedConvertDto convertDto = new SharedConvertDto();
        convertDto.setTempUrl("https://v5qy.te.baibaodun.com.cn/obpm/uploads/2022/10-26/_MIFnVvYFZZjw5fN3OtS/1666772764122/qualicerttemp_zgz.html");
        String con = "{\"address\":\"\u5c71\u897f\u7701\u6cb3\u6d25\u5e02\u6a0a\u6751\u9547\u5e72\u6da7\u6751\",\"certificateno\":\"\u4eac2023254021\",\"day\":\"15\",\"fzDate\":\"2023-07-18\",\"headphoto\":\"https://02obs.baibaodun.cn/2024/10-11/1172a4fc-9357-4370-ab7b-c99f69c07f1c/1728630228970.jpg\",\"idcardno\":\"140882200411150018\",\"isSignature\":\"1\",\"month\":\"11\",\"name\":\"\u53f2\u6893\u5f6c\",\"unSignaturePDF\":\"/uploads/pdf/dianziqianzhang/temp/queueId_205459.temp\",\"year\":\"2004\",\"zDay\":\"18\",\"zMonth\":\"07\",\"zYear\":\"2023\"}";
        convertDto.setFormData(JSON.parse((String)con));
        PDFUtils.generatePdfByOpenhtmltopdf(convertDto.getTempUrl(), "D:\\data\\upload\\a902.pdf", convertDto.getFormData());
    }

    public String existsPdfCopy(SharedConvertDto convertDto) {
        int count = 80;
        if (convertDto.getFormData() != null) {
            count = Integer.parseInt(String.valueOf(convertDto.getFormData()));
        }
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        String tempFilePath = this.rootPath + convertDto.getTempUrl();
        String inFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/in");
        System.err.println("=======> existsPdfCopy.tempFilePath:" + tempFilePath);
        System.err.println("=======> existsPdfCopy.inFilePath:" + inFilePath);
        File tempFile = new File(tempFilePath);
        if (!tempFile.exists()) {
            return null;
        }
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return null;
        }
        File[] fi = inFile.listFiles();
        if (fi != null && fi.length > 20) {
            log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u5269\u4f59\u6587\u4ef6\u8d8520\u4e2a\uff0c\u6253\u56de");
            return null;
        }
        File[] fa = tempFile.listFiles();
        int pCount = 0;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < fa.length; ++i) {
            if (!fa[i].getName().contains(".pdf") || pCount >= count) continue;
            list.add(fa[i].getName());
            ++pCount;
        }
        if (list.size() == 0) {
            return null;
        }
        ArrayList usrlist = Lists.newArrayList();
        for (String fileName : list) {
            try {
                File temp = new File(tempFilePath + "/" + fileName);
                if (!temp.exists()) continue;
                Files.move(Paths.get(tempFilePath + "/" + fileName, new String[0]), Paths.get(inFilePath + "/" + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                usrlist.add(fileName);
            }
            catch (IOException e) {
                log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\uff1a" + fileName + "\uff0cERROR\uff1a" + e.getMessage());
            }
        }
        log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u5df2\u526a\u5207\uff1a" + usrlist.size() + "\u4e2a");
        StringBuilder result = new StringBuilder();
        for (String fileName : usrlist) {
            result.append(fileName);
            result.append(";");
        }
        return "0," + result;
    }

    public File[] findInFile(String tempUrl) {
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            System.err.println("=======> existsPdfCopy.findInFile.inFile:null");
            return null;
        }
        File[] fi = inFile.listFiles();
        System.err.println("=======> existsPdfCopy.findInFile.fi:" + fi);
        if (fi.length == 0) {
            System.err.println("=======> existsPdfCopy.findInFile.fi:null");
            return null;
        }
        return fi;
    }

    public void delInPDF(SharedConvertDto convertDto) {
        String inFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/in");
        String outFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/out");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File outFile = new File(outFilePath);
        if (!outFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        File[] ofi = outFile.listFiles();
        if (ifi.length != 0 && ofi.length != 0) {
            File fs;
            int i;
            String outFName = "";
            for (i = 0; i < ofi.length; ++i) {
                fs = ofi[i];
                outFName = outFName + fs.getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)outFName)) {
                for (i = 0; i < ifi.length; ++i) {
                    fs = ifi[i];
                    if (!outFName.contains(fs.getName()) || !fs.exists()) continue;
                    fs.delete();
                }
            }
        }
    }

    public void delSetFtpFile(String tempUrl, String fileNames) {
        File[] ofi;
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        String outFilePath = this.rootPath + tempUrl.replace("/temp", "/out");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File outFile = new File(outFilePath);
        if (!outFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        if (ifi.length != 0) {
            for (int i = 0; i < ifi.length; ++i) {
                File fs = ifi[i];
                if (!fileNames.contains(fs.getName()) || !fs.exists()) continue;
                fs.delete();
            }
        }
        if ((ofi = outFile.listFiles()).length != 0) {
            for (int i = 0; i < ofi.length; ++i) {
                File fs = ofi[i];
                if (!fileNames.contains(fs.getName()) || !fs.exists()) continue;
                fs.delete();
            }
        }
    }

    public void delInPDF(String tempUrl) {
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        for (int i = 0; i < ifi.length; ++i) {
            File fs = ifi[i];
            if (fs.length() >= 5L) continue;
            fs.delete();
        }
    }

    public String existsScanSignature(SharedConvertDto convertDto) {
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        return PDFUtils.uploadFtpFile(convertDto.getTempUrl(), this.rootPath);
    }

    public String existsScanSignatureByDayFile(SharedConvertDto convertDto) {
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        return PDFUtils.uploadDayFile(convertDto.getTempUrl(), this.rootPath);
    }
}

