package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxProductBenefits;
import com.zbkj.service.dao.BcxProductBenefitsDao;
import com.zbkj.service.service.BcxProductBenefitsService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * description：福利配置表 服务接口
 * author：linchunpeng
 * date：2024/1/26
 */
@Service
public class BcxProductBenefitsServiceImpl extends ServiceImpl<BcxProductBenefitsDao, BcxProductBenefits> implements BcxProductBenefitsService {
    
    @Resource
    private BcxProductBenefitsDao dao;

    /**
     * 根据商品id，查询授权的企业列表
     */
    @Override
    public List<BcxProductBenefits> findListByProductId(Integer productId) {
        LambdaQueryWrapper<BcxProductBenefits> lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxProductBenefits::getProductId, productId);
        Date nowTime = new Date();
        lqw.and(wrapper -> wrapper.le(BcxProductBenefits::getAuthStartTime, nowTime).or().isNull(BcxProductBenefits::getAuthStartTime));
        lqw.and(wrapper -> wrapper.ge(BcxProductBenefits::getAuthEndTime, nowTime).or().isNull(BcxProductBenefits::getAuthEndTime));
        return dao.selectList(lqw);
    }

    /**
     * 根据企业id，查询授权的商品列表
     */
    @Override
    public List<BcxProductBenefits> findListByCompanyId(String companyId) {
        LambdaQueryWrapper<BcxProductBenefits> lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxProductBenefits::getCompanyId, companyId);
        Date nowTime = new Date();
        lqw.and(wrapper -> wrapper.le(BcxProductBenefits::getAuthStartTime, nowTime).or().isNull(BcxProductBenefits::getAuthStartTime));
        lqw.and(wrapper -> wrapper.ge(BcxProductBenefits::getAuthEndTime, nowTime).or().isNull(BcxProductBenefits::getAuthEndTime));
        return dao.selectList(lqw);
    }
}