package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.model.bcx.BcxDepartmentMemberServe;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxDepartmentMemberSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;
import com.zbkj.service.dao.BcxDepartmentMemberDao;
import com.zbkj.service.service.BcxDepartmentMemberServeService;
import com.zbkj.service.service.BcxDepartmentMemberService;
import com.zbkj.service.service.BcxDepartmentService;
import com.zbkj.service.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description: 部门成员表 服务实现类
 * author : linchunpeng
 * date : 2023/8/3
 */
@Service
public class BcxDepartmentMemberServiceImpl extends ServiceImpl<BcxDepartmentMemberDao, BcxDepartmentMember> implements BcxDepartmentMemberService {

    @Resource
    private BcxDepartmentMemberDao dao;

    @Autowired
    private BcxDepartmentService bcxDepartmentService;

    @Resource
    private BcxDepartmentMemberServeService bcxDepartmentMemberServeService;

    @Resource
    private UserService userService;

    /**
     * description：获取部门成员tree列表
     * author：linchunpeng
     * date：2023/8/7
     */
    @Override
    public List<BcxDepartmentResponse> findAllTree() {
        List<BcxDepartmentMember> allList = this.list();
        if (CollectionUtil.isEmpty(allList)) {
            return new ArrayList<>();
        }
        List<BcxDepartmentMemberResponse> memberList = allList.stream().map(this::getBcxDepartmentMemberResponse).collect(Collectors.toList());
        List<BcxDepartmentResponse> responseList = bcxDepartmentService.findAllTreeWithMember(memberList);
        return responseList;
    }

    /**
     * description：获取BcxDepartmentMemberResponse对象
     * author：linchunpeng
     * date：2023/8/4
     */
    private BcxDepartmentMemberResponse getBcxDepartmentMemberResponse(BcxDepartmentMember member) {
        BcxDepartmentMemberResponse response = new BcxDepartmentMemberResponse();
        response.setId(member.getId());
        response.setDeptId(member.getDepartmentId());
        response.setName(member.getName());
        return response;
    }

    /**
     * description：根据v5id查询部门成员
     * author：linchunpeng
     * date：2023/8/21
     */
    @Override
    public BcxDepartmentMember findByBcxId(String bcxId) {
        QueryWrapper<BcxDepartmentMember> queryWrapper = Wrappers.query();
        queryWrapper.eq("bcx_id", bcxId);
        return this.getOne(queryWrapper);
    }


    /**
     * description：分页查询部门成员列表
     * author：linchunpeng
     * date：2023/8/25
     */
    @Override
    public PageInfo<BcxDepartmentMemberResponse> getPage(BcxDepartmentMemberSearchRequest request, PageParamRequest pageParamRequest) {
        HashMap<String, Object> map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank(request.getName())) {
            map.put("name", request.getName());
        }
        if (ObjectUtil.isNotNull(request.getDepartmentName())) {
            map.put("departmentName", request.getDepartmentName());
        }
        Page<BcxPerformanceReport> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxDepartmentMemberResponse> list = dao.selectListByParam(map);
        return CommonPage.copyPageInfo(page, list);
    }

    @Override
    public String getMemerNamesByUid(Integer uid) {
        User user = userService.getById(uid);
        if (ObjectUtil.isNull(user)) {
            return "";
        }
        LambdaQueryWrapper<BcxDepartmentMemberServe> qw = Wrappers.lambdaQuery();
        qw.eq(BcxDepartmentMemberServe::getOrgId, user.getAccount());
        List<BcxDepartmentMemberServe> list = bcxDepartmentMemberServeService.list(qw);
        if (list.isEmpty()) {
            return "";
        }
        LambdaQueryWrapper<BcxDepartmentMember> lqw = Wrappers.lambdaQuery();
        lqw.in(BcxDepartmentMember::getBcxId, list.stream().map(BcxDepartmentMemberServe::getBcxId).collect(Collectors.toList()));
        List<BcxDepartmentMember> members = dao.selectList(lqw);
        if (members.isEmpty()) {
            return "";
        }
        return members.stream().map(BcxDepartmentMember::getName).collect(Collectors.joining(","));
    }
}