package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2MerchantBasicdataSettlementQueryRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 结算记录查询 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2MerchantBasicdataSettlementQueryRequest.class)
public class V2MerchantBasicdataSettlementQuery {

    public static V2MerchantBasicdataSettlementQueryRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2MerchantBasicdataSettlementQueryRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2MerchantBasicdataSettlementQueryRequest.class);
//        V2MerchantBasicdataSettlementQueryRequest request = new V2MerchantBasicdataSettlementQueryRequest();
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 汇付客户Id
//        request.setHuifuId("6666000111938435");
        // 结算开始日期
//        request.setBeginDate("20200810");
        // 结算结束日期
//        request.setEndDate("20200810");
        // 分页条数
//        request.setPageSize("10");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 结算方式
//        extendInfoMap.put("settle_cycle", "");
        // 分页页码
        extendInfoMap.put("page_num", map.get("pageNum"));
        // 交易状态
//        extendInfoMap.put("trans_stat", "I");
        // 排序字段
//        extendInfoMap.put("sort_column", "10");
        // 排序顺序
//        extendInfoMap.put("sort_order", "DESC");
        return extendInfoMap;
    }

}
