package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bcx.BcxPayOfflineFile;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxPayOfflineFileRequest;
import com.zbkj.common.response.bcx.BcxPayOfflineFileResponse;
import com.zbkj.service.dao.bcx.BcxPayOfflineFileDao;
import com.zbkj.service.service.bcx.BcxPayOfflineFileService;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
/**
 * 线下支付凭证 服务实现类
 */
@Service
public class BcxPayOfflineFileServiceImpl extends ServiceImpl<BcxPayOfflineFileDao, BcxPayOfflineFile> implements BcxPayOfflineFileService {

    @Resource
    private BcxPayOfflineFileDao dao;

    @Override
    public BcxPayOfflineFileResponse queryById(Integer id){
        BcxPayOfflineFile source = dao.selectById(id);
        BcxPayOfflineFileResponse target = transform(source);
        return target;
    }

    @Override
    public PageInfo<BcxPayOfflineFileResponse> queryPagedList(BcxPayOfflineFileRequest request,
                                                              PageParamRequest pageParamRequest){
        LambdaQueryWrapper<BcxPayOfflineFile> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxPayOfflineFile::getId,request.getId());
        lqw.orderByDesc(BcxPayOfflineFile::getId);
        Page<BcxPayOfflineFile> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxPayOfflineFile> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxPayOfflineFileResponse> result = transform(sources);
        return CommonPage.copyPageInfo(page, result);
    }

    @Override
    public List<BcxPayOfflineFile> queryByOrderNo(String orderNo) {
        LambdaQueryWrapper<BcxPayOfflineFile> query = new LambdaQueryWrapper<>();
        query.eq(BcxPayOfflineFile::getOrderNo, orderNo);
        return dao.selectList(query);
    }

    private List<BcxPayOfflineFileResponse> transform(List<BcxPayOfflineFile> sources) {
        List<BcxPayOfflineFileResponse> result = new ArrayList<>();
        for (BcxPayOfflineFile source : sources) {
            BcxPayOfflineFileResponse target = transform(source);
            result.add(target);
        }
        return result;
    }
    private BcxPayOfflineFileResponse transform(BcxPayOfflineFile source) {
        BcxPayOfflineFileResponse target = new BcxPayOfflineFileResponse();
        BeanUtils.copyProperties(source, target);
        // set another perperties
        return target;
    }
}
