package com.zbkj.service.wangshang.notify.service.impl;


import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWallet;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.common.model.huifu.HuifuWalletProcess;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletDao;
import com.zbkj.service.dao.HuifuWalletProcessDao;
import com.zbkj.service.huifu.constants.OpenProcess;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkmbpStmtApplyResultCommonNotifyModel;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkmbpStmtApplyResultCommonNotifyRequest;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 通用下载申请结果通知（异步场景）
 * ant.mybank.bkmbp.stmt.apply.result.common.notify
 **/
@Service(value = "bkmbpStmtApplyResultCommonNotifyService")
public class BkmbpStmtApplyResultCommonNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkmbpStmtApplyResultCommonNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 通用下载申请结果通知（异步场景）:ant.mybank.bkmbp.stmt.apply.result.common.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        BkmbpStmtApplyResultCommonNotifyRequest bkmbpStmtApplyResultCommonNotifyRequest =
                XmlConverter.getInstance().toResponse(context, BkmbpStmtApplyResultCommonNotifyRequest.class);
        RequestHead head = bkmbpStmtApplyResultCommonNotifyRequest.getBkmbpStmtApplyResultCommonNotify().getRequestHead();
        //通知内容保存
        boolean flag = saveNotify(bkmbpStmtApplyResultCommonNotifyRequest.getBkmbpStmtApplyResultCommonNotify().getBkmbpStmtApplyResultCommonNotifyModel());
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("通用下载申请结果通知（异步场景）:ant.mybank.bkmbp.stmt.apply.result.common.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkmbpStmtApplyResultCommonNotifyModel model) {
        //TODO

        return true;
    }

}
