package com.zbkj.service.wangshang.api.internal.parser.xml;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankParser;
import com.zbkj.service.wangshang.api.MybankResponse;

/**
 * XML对象解析器
 */
public class ObjectXmlParser<T extends MybankResponse> implements MybankParser<T> {

    private Class<T> clazz;

    public ObjectXmlParser(Class<T> clazz) { this.clazz = clazz; }

    @Override
    public T parse(String responseXml) throws MybankApiException {
        XmlConverter converter = XmlConverter.getInstance();
        return converter.toResponse(responseXml, clazz);
    }

    @Override
    public Class<T> getResponseClass() {
        return clazz;
    }
}