package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.SysConfigConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemConfig;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.CommonConfigDao;
import com.zbkj.service.service.CommonConfigService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <b> 通用配置业务 </b>
 * @author ZXF
 * @create 2023/08/07 0007 14:46
 * @version
 * @注意事项 </b>
 */
@Service
public class CommonConfigServiceImpl implements CommonConfigService {

    @Resource
    private CommonConfigDao commonConfigDao;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private CrmebConfig crmebConfig;

    @Autowired
    private FrontTokenComponent tokenComponent;

    /**
     * 获取当前用户ID，带异常
     */
    @Override
    public Integer getUserId() {
        Integer userId = tokenComponent.getUserId();
//        String code = "373";
        if (userId == null) {
            throw CommonResultCode.PERMISSION_EXPIRATION.newException();
        }
        return userId;
    }

    /**
     * 获取当前用户identify_no，带异常
     */
    @Override
    public String getAccoutCode() {
        String code = tokenComponent.accoutCode();
//        String code = "373";
        if (StringUtils.isEmpty(code)) {
            throw CommonResultCode.PERMISSION_EXPIRATION.newException();
        }
        return code;
    }

    /**
     * 根据menu name 获取 value
     *
     * @param name menu name
     * @return String
     */
    @Override
    public String getValueByKey(String name) {
        return get(name);
    }

    private void asyncBlank(String key) {
        redisUtil.hset(SysConfigConstants.CONFIG_LIST, key, "");
    }

    private void async(SystemConfig systemConfig) {
        redisUtil.hset(SysConfigConstants.CONFIG_LIST, systemConfig.getName(), systemConfig.getValue());
    }

    /**
     * 把数据同步到redis
     *
     * @param systemConfigList List<SystemConfig> 需要同步的数据
     */
    private void async(List<SystemConfig> systemConfigList) {
        for (SystemConfig systemConfig : systemConfigList) {
            redisUtil.hset(SysConfigConstants.CONFIG_LIST, systemConfig.getName(), systemConfig.getValue());
        }
    }

    /**
     * 把数据同步到redis
     *
     * @param name String
     * @return String
     */
    private String get(String name) {
        if (!crmebConfig.isAsyncConfig()) {
            SystemConfig systemConfig = commonConfigDao.getSConfigByName(name);
            if (ObjectUtil.isNull(systemConfig) || StrUtil.isBlank(systemConfig.getValue())) {
                return "";
            }
            return systemConfig.getValue();
        }
        Long size = redisUtil.getHashSize(SysConfigConstants.CONFIG_LIST);
        if (size <= 0) {
            SystemConfig systemConfig = commonConfigDao.getSConfigByName(name);
            if (ObjectUtil.isNull(systemConfig) || StrUtil.isBlank(systemConfig.getValue())) {
                asyncBlank(name);
                return "";
            }
            async(systemConfig);
            return systemConfig.getValue();
        }
        Object data = redisUtil.hget(SysConfigConstants.CONFIG_LIST, name);
        if (ObjectUtil.isNull(data)) {
            asyncBlank(name);
            return "";
        }
        return data.toString();
    }

}

