package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.dto.*;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.huifu.*;
import org.springframework.scheduling.annotation.Async;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/08/01 0001 13:19
 * @version
 * @注意事项 </b>
 */
public interface HuifuWalletService extends IService<HuifuWallet> {


    /**
     * <b> 异步执行冻结金额计算 </b>
     * @author ZXF
     * @create 2023/09/15 0015 17:48
     * @version
     * @注意事项 </b>
     */
    void syncUpdateSumFrozenAmount(String uniId, BigDecimal amount);


    /**
     * <b> 异步执行平台分账 </b>
     * @author ZXF
     * @create 2023/09/15 0015 17:48
     * @version
     * @注意事项 </b>
     */
    void syncTransferToPlat(HuifuWalletTransferDto dto);

    /**
     * 获取企业钱包服务开通情况
     *
     * @param huifuWallet
     * @return
     * @author llc
     * @date 2019-06-21
     */
    Map<String, String> getHuifuWalletServiceOpenInfo(HuifuWallet huifuWallet);

    /**
     * 获取企业钱包服务当前开通步骤
     *
     * @param huifuWalletProcess
     * @return
     * @author llc
     * @date 2019-06-21
     */
    HuifuWalletProcess getHuifuWalletCurrentProcess(HuifuWalletProcess huifuWalletProcess);


    /**
     * 保存开户资料
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     * @update by llc 2020-09-10
     */
    String saveAccountInfo(HuifuWalletAccountDto dto) throws CrmebWalletException;


    /**
     * 保存开户资料第二步
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    String saveAccountInfoStepTwo(HuifuWalletBusiDto dto) throws CrmebWalletException;

    /**
     * <b> 组装激活二维码 </b>
     * @author ZXF
     * @create 2025/06/12 0012 16:46
     * @version
     * @注意事项 </b>
     */
    String getActiveUrl(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;
    /**
     * <b> 组装登录小程序二维码 </b>
     * @author ZXF
     * @create 2025/06/12 0012 16:46
     * @version
     * @注意事项 </b>
     */
    String getACXLoginUrl(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 查询入驻申请状态（设置步骤） </b>
     * @author ZXF
     * @create 2025/06/13 0013 17:38
     * @version
     * @注意事项 </b>
     */
    HuifuWalletAccountDto getHuifuWalletAccountStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 商户修改结果查询 </b>
     * @author ZXF
     * @create 2025/06/23 0023 23:49
     * @version
     * @注意事项 </b>
     */
    HuifuWalletAccountDto huifuWalletAccountUpdateStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 激活状态查询 </b>
     * @author ZXF
     * @create 2025/06/25 0025 17:12
     * @version
     * @注意事项 </b>
     */
    HuifuWalletAccountDto huifuWalletAccountActiveStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 查询商户信息 </b>
     * @author ZXF
     * @create 2025/06/23 0023 13:41
     * @version
     * @注意事项 </b>
     */
    Object getHuifuWalletAccountDetail(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * 获取企业钱包账户
     *
     * @param huifuWalletAccount
     * @author llc
     * @date 2019-06-21
     */
    HuifuWalletAccountDto getHuifuWalletAccount(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * 获取企业钱包账户 协议代扣授权状态
     *
     * @param huifuWalletAccount
     * @return
     * @author llc
     * @date 2019-06-21
     */
    void getHuifuWalletAccountArrangementStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 解约申请审核确认 </b>
     * @author ZXF
     * @create 2025/06/14 0014 17:06
     * @version
     * @注意事项 </b>
     */
    String checkArrangementAudit(HuifuWalletAccountDto huifuWalletAccount) throws CrmebWalletException;

    BigDecimal getHuifuWallectBalanceByUniId(String uniId) throws CrmebWalletException;

    /**
     * 获取企业钱包账户金额
     *
     * @param huifuWalletAccount
     * @author llc
     * @date 2019-06-24
     */
    Map<String, String> getHuifuWalletAccountAmount(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 账户余额查询 </b>
     * @author ZXF
     * @create 2025/06/23 0023 11:46
     * @version
     * @注意事项 </b>
     */
    Map<String, String> getAccountBlanance(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException;

    /**
     * <b> 获取企业钱包账户交易明细（请求转存数据，当天只能查到昨天的数据） </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    PageInfo<HuifuWalletAccountDetail> thisHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto) throws CrmebWalletException;

    /**
     * 导出企业钱包账户交易明细数据
     *
     * @author llc
     * @date 2019-09-20
     */
    String exportHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto, HttpServletResponse response) throws CrmebWalletException;

    String huifuWalletAccountTradeDetailSch();

    String huifuWalletAccountTradeDetailTask(String startDate, String endDate);

    void updateBalance(String startDate, String endDate);

    /**
     * <b> 余额支付交易分账明细查询 定时任务 </b>
     * @author ZXF
     * @create 2023/11/13 0013 23:31
     * @version
     * @注意事项 </b>
     */
    void payTradeDetailTaskSch();

    /**
     * <b> 查询交易信息 </b>
     * @author ZXF
     * @create 2025/06/22 0022 15:19
     * @version
     * @注意事项 </b>
     */
    void getPayTradeDetailTask(String uniId,String accountNo,String hfSeqId,String tradeDate);


    /**
     * 交易分账明细查询接口（废弃）
     *
     * @param accountNo 商户号
     * @param hfSeqId 全局流水号
     * @param ordType 交易类型 0反向1正向
     * @return
     * @author lp
     * @date 2019-12-09
     */
    void tradeDetailTask(String accountNo,String hfSeqId,int ordType) throws CrmebWalletException;

    /**
     * 获取企业钱包充值token
     *
     * @param dto
     * @author llc
     * @date 2019-06-26
     */
    String getWalletRechargeToken(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * 企业钱包充值回调
     *
     * @param dto
     * @author llc
     * @date 2019-06-28
     */
    String huifuWalletRechargeCallback(HuifuRequestDataDto dto);

    /**
     * 企业钱包提现回调
     *
     * @param messageBody
     * @author llc
     * @date 2019-06-28
     */
    String huifuWalletExtractCallback(String messageBody);

    /**
     * 获取企业充值交易状态
     *
     * @param huifuWalletTrade
     * @author llc
     * @date 2019-06-28
     */
    HuifuWalletTrade getWalletTradeInfo(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException;

    /**
     * <b> 根据业务编码或业务交易流水号查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:20
     * @version
     * @注意事项 </b>
     */
    List<HuifuWalletTrade> getHuifuWalletTradeBySeqAndCode(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException;

    /**
     * 企业钱包账户提现
     *
     * @param dto
     * @author llc
     * @date 2019-06-26
     */
    String huifuWalletAccountExtract(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * 企业钱包账户提现确认
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    String huifuWalletAccountExtractConfirm(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * <b> 测试离线对账文件查询 </b>
     * @author ZXF
     * @create 2025/06/23 0023 16:43
     * @version
     * @注意事项 </b>
     */
    Map<String, Object> executeReconcile(String tradeDate) throws CrmebWalletException;

    /**
     * <b> 企业账户金额 冻结 </b>
     * @author ZXF
     * @create 2023/11/10 0010 10:52
     * @version
     * @注意事项 </b>
     */
    String freeze(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 企业账户金额 解冻 </b>
     * @author ZXF
     * @create 2023/11/10 0010 10:52
     * @version
     * @注意事项 </b>
     */
    String thaw(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 企业 转账+解冻 接口 </b>
     * @author ZXF
     * @create 2023/11/10 0010 11:02
     * @version
     * @注意事项 </b>
     */
    String payAndThaw(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 企业 转账 接口 </b>
     * @author ZXF
     * @create 2023/11/10 0010 11:02
     * @version
     * @注意事项 </b>
     */
    String pay(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * 企业账户金额冻结/解冻
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    String huifuWalletAccountLock(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * (平台分账业务)企业账户金额冻结/解冻
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    String platHuifuWalletAccountLock(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 冻结/解冻业务逻辑判断，计算记录冻结金额并入库 </b>
     * @param tradeType 交易类型 04冻结05解冻
     * @param amount 交易金额
     * @author ZXF
     * @create 2023/03/31 0031 9:58
     * @version
     * @注意事项 </b>
     */
    BigDecimal extractedLock(String uniId, String tradeType, String amount) throws CrmebWalletException;

    /**
     * 线下支付业务新增平台分账业务 转账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    void offlinePayPlatTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * 企业消费转账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    String huifuWalletAccountTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException;

    String refundQuery(HuifuWalletAccountDto dto) throws CrmebWalletException;

    String batchQuery(HuifuWalletAccountDto dto) throws CrmebWalletException;

    String refundApply(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * <b> 订单退款申请 </b>
     * @author ZXF
     * @create 2025/06/23 0023 20:52
     * @version
     * @注意事项 </b>
     */
    String huifuWalletAccountRefundApply(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * <b> 订单退款结果查询 </b>
     * @author ZXF
     * @create 2025/06/23 0023 20:52
     * @version
     * @注意事项 </b>
     */
    Map<String, Object> huifuWalletAccountRefundQuery(HuifuWalletAccountDto dto) throws CrmebWalletException;

    /**
     * 企业分账给平台
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    Boolean transferToPlat(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 线下支付业务 退款接口 </b>
     * @author ZXF
     * @create 2023/11/15 0015 19:17
     * @version
     * @注意事项 </b>
     */
    void offlinePayPlatRefund(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 企业退款接口 </b>
     * @author ZXF
     * @create 2023/11/15 0015 19:17
     * @version
     * @注意事项 </b>
     */
    String huifuWalletAccountRefund(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 平台退款给企业 </b>
     * @author ZXF
     * @create 2023/11/15 0015 19:17
     * @version
     * @注意事项 </b>
     */
    Boolean refundToPlat(HuifuWalletTransferDto dto) throws CrmebWalletException;

    /**
     * <b> 平台分销转账接口 </b>
     * @author ZXF
     * @create 2023/08/24 0024 14:57
     * @version
     * @注意事项 </b>
     */
    String platAccountRetailTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException;

    String getHuifuAccountTradeVoucher(HuifuWalletTradeDto dto) throws CrmebWalletException;

    /**
     * 测试汇总电子回单查询
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-07-08
     */
    String getBatchTradeVoucher(HuifuWalletTradeDto dto) throws CrmebWalletException;

    /**
     * <b> 电子回单获取任务 </b>
     * @author ZXF
     * @create 2023/04/21 0021 17:06
     * @version
     * @注意事项 </b>
     */
    String taskTradeVoucher(String tradeDate);

    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-09-16
     */
    String createHuifuWalletReconciliation();

    /**
     * <b> 初始生成化对账单配置 </b>
     * @author ZXF
     * @create 2023/08/12 0012 13:33
     * @version
     * @注意事项 </b>
     */
    String setReconciliationConfig() throws CrmebWalletException;

    /**
     * <b> 交易结算对账文件重新生成 </b>
     * @param tradeDate 指定日期，例：20230816
     * @author ZXF
     * @create 2023/08/12 0012 13:33
     * @version
     * @注意事项 </b>
     */
    String reconciliationReplay(String tradeDate);

    /**
     * 获取企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-19
     */
    Map<String, Object> getHuifuWalletReconciliation(HuifuWalletTradeDto dto) throws CrmebWalletException;

    /**
     * 导出企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-20
     */
    String exportHuifuWalletReconciliation(HuifuWalletTradeDto dto, HttpServletResponse response) throws CrmebWalletException;

    /**
     * <b> 获取企业钱包账户提现记录 </b>
     * @author ZXF
     * @create 2023/08/06 0006 13:02
     * @version
     * @注意事项 </b>
     */
    String huifuWalletAccountTranslogTask(String startDate, String endDate) throws CrmebWalletException;

    /**
     * <b> 获取平台下所以收费账单记录 </b>
     * 支持 1收费账单明细 2收费日账单文件 3收费月账单文件
     * @author ZXF
     * @create 2023/08/06 0006 13:02
     * @version
     * @注意事项 </b>
     */
    String huifuWalletAccountFeeFileApply(String stmtType,String startDate, String endDate) throws CrmebWalletException;

    /**
     * <b> 查询收费账单申请记录 </b>
     * 支持 1收费账单明细 2收费日账单文件 3收费月账单文件
     * @author ZXF
     * @create 2023/08/06 0006 13:02
     * @version
     * @注意事项 </b>
     */
    Map<String, Object> huifuWalletAccountFeeFileQuery(String stmtType,String outRequestNo, String backOrderNo) throws CrmebWalletException;

    /**
     * <b> 获取企业钱包账户提现明细（请求转存数据，当天只能查到昨天的数据） </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    PageInfo<HuifuWalletTranslog> thisHuifuWalletTranslog(HuifuWalletTranslogDto dto) throws CrmebWalletException;

    /**
     * <b> C端转账接口 - 聚合正扫 </b>
     * @author ZXF
     * @create 2023/08/24 0024 11:31
     * @version
     * @注意事项 </b>
     */
    String huifuJspayTransfer(JsPayTransferDto dto) throws CrmebWalletException;

    /**
     * <b> C端聚合正扫记录加入交易详情表 </b>
     * @author ZXF
     * @create 2023/08/25 0025 16:43
     * @version
     * @注意事项 </b>
     */
    void jspayAddAccountDetail(JsPayTrade jsPayTrade) throws CrmebWalletException;

    /**
     * <b> C端退款接口 - 扫码交易退款 </b>
     * @author ZXF
     * @create 2023/08/24 0024 11:31
     * @version
     * @注意事项 </b>
     */
    String huifuJspayRefund(JsPayTransferDto dto) throws CrmebWalletException;

    /**
     * <b> C端交易退款查询接口 </b>
     * @author ZXF
     * @create 2023/08/24 0024 11:31
     * @version
     * @注意事项 </b>
     */
    String huifuJspayRefundQuery(JsPayTransferDto dto) throws CrmebWalletException;

    void testLock(String uniId, String tradeType, String amount);
}
