
CREATE TABLE `com_order_detail` (
  `comOrderDetailId` bigint(20) NOT NULL COMMENT '企业订单详情ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `productName` varchar(500) DEFAULT NULL COMMENT '产品名称',
  `eachAmount` decimal(10,2) NOT NULL COMMENT '单价',
  `unit` varchar(20) DEFAULT NULL COMMENT '单位',
  `num` int(6) DEFAULT NULL COMMENT '数量',
  `duration` int(6) DEFAULT NULL COMMENT '时长',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '订单金额',
  `productBuyModeId` varchar(8) NOT NULL COMMENT '产品购买方式ID',
  `comOrderId` bigint(20) NOT NULL COMMENT '企业订单ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `expireTime` datetime DEFAULT NULL COMMENT '到期时间',
  PRIMARY KEY (`comOrderDetailId`),
  KEY `index_com_order_detail_comOrderId` (`comOrderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业订单详情';


CREATE TABLE `com_order` (
  `comOrderId` bigint(20) NOT NULL COMMENT '企业订单ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `productCategoryType` varchar(6) NOT NULL COMMENT '产品范畴类型',
  `orderStatus` varchar(6) DEFAULT NULL COMMENT '订单状态',
  `orderDeployStatus` varchar(6) DEFAULT NULL COMMENT '订单配置状态',
  `amount` decimal(10,2) NOT NULL COMMENT '订单金额',
  `actualPayAmount` decimal(10,2) NOT NULL COMMENT '实际支付金额',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `assignedOrgType` varchar(6) DEFAULT NULL COMMENT '分配组织类型',
  `assignedOrgId` bigint(20) DEFAULT NULL COMMENT '分配组织ID',
  `purchaseStatus` varchar(6) DEFAULT NULL COMMENT '资源采购状态',
  `deliveryAddress` varchar(100) DEFAULT NULL COMMENT '收货地址',
  PRIMARY KEY (`comOrderId`),
  KEY `index_com_order_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业订单';

CREATE TABLE `config_product_category` (
  `productCategoryType` varchar(6) NOT NULL COMMENT '产品范畴类型',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `name` varchar(50) DEFAULT NULL COMMENT '产品范畴名称',
  `remark` varchar(100) DEFAULT NULL COMMENT '描述',
  `productCategoryUrl` varchar(200) DEFAULT NULL COMMENT '图片URL',
  PRIMARY KEY (`productCategoryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品范畴';

INSERT INTO  `config_product_category` (`productCategoryType`, `isActive`, `name`, `remark`, `productCategoryUrl`) VALUES ('11', '1', '云会议', '警企、企企、企内云会议服务，支持软硬件开会。快速一键入会，一体化会控功能', NULL);


INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('59', '支付平台地址', 'PAYMENT_PLATFORM_URL', 'http://pay.bcxin.com.cn:81/', 'Y', 'admin', '2021-06-08 14:56:25', '', NULL, '支付平台地址');
INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('60', '会议收入企业ID', 'MEET_INCOME_COMID', '664891052041175040', 'Y', 'admin', '2021-06-08 16:15:36', '', NULL, '会议收入企业ID');

INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('18', '订单状态', 'orderStatus', '0', 'admin', '2021-06-08 16:23:53', '', NULL, '订单状态');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('19', '订单配置状态', 'orderDeployStatus', '0', 'admin', '2021-06-08 16:23:53', '', NULL, '订单配置状态');

INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('348', '1', '配置中', '0', 'orderDeployStatus', '', '', 'N', '0', 'admin', '2021-06-08 16:25:40', NULL, NULL, '配置中');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('349', '2', '配置完成', '1', 'orderDeployStatus', '', '', 'N', '0', 'admin', '2021-06-08 16:25:40', NULL, NULL, '配置完成');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('351', '1', '未支付', '0', 'orderStatus', '', '', 'N', '0', 'admin', '2021-06-08 16:25:45', NULL, NULL, '未支付');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('352', '2', '已支付', '1', 'orderStatus', '', '', 'N', '0', 'admin', '2021-06-08 16:25:45', NULL, NULL, '已支付');

