import Vue from 'vue'
import Router from 'vue-router'
import Main from './views/Main.vue'
import Opener from './views/Opener.vue'
import Launch from './views/main_launch.vue'
import Pending from './views/main_pending.vue'
import Processing from './views/main_processing.vue'
//import printView from './components/print_view.vue'
// import Personal from './components/Personal.vue'
import Home from './views/Home.vue'
import HomeRT from './views/HomeRT.vue'


Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      name: 'main',
      component: localStorage.getItem('homeTemplateBoradType')=='rtpayTemplate'?HomeRT:Home  //根据ip判断皮肤模板组件
      // component:()=> import('./views/Main.vue')
      // component: () => import('./views/Home.vue') //自定义首页---关联home.scss 记住
    },
    {
      path: '/about',
      name: 'about',
      component: () => import(/* webpackChunkName: "about" */ './views/About.vue')
    },
    {
      path: '/rail',
      name: 'rail',
      component: () => import(/* webpackChunkName: "rail" */ './views/ElectronicFence.vue')
    },
    {
      path: '/printView',
      name: 'printView',
      component: () => import('./components/print_view.vue')
    },
    {
      path: '/certificate',
      name: 'certificate',
      component: () => import(/* webpackChunkName: "certificate" */ './views/Certificate.vue')
    },
    {
      path: '/formPrint',
      name: 'formPrint',
      component: () => import('./components/form_print.vue')
    },
    {
      path: '/view_blank',
      name: 'view_blank',
      component: () => import('./components/view_blank.vue')
    },
    {
      path: '/form_blank',
      name: 'form_blank',
      component: () => import('./components/form_blank.vue')
    },
    {
      path: '/test',
      name: 'test',
      component: () => import('./components/test.vue')
    },
    {
      path: '/open',
      name: 'open',
      component: Opener,
      meta: {
        keepAlive: true,
      }
    },
    {
      path: '/launch',
      name: 'launch',
      component: Launch,
      meta: {
        keepAlive: true,
        title: '发起新建'
      }
    },
    {
      path: '/pending',
      name: 'pending',
      component: Pending,
      meta: {
        keepAlive: true,
        title: '待办'
      }
    },
    {
      path: '/processing',
      name: 'processing',
      component: Processing,
      meta: {
        keepAlive: true,
        title: '待办'
      }
    },

    // {
    //   path: '/flowDialog',
    //   name: 'flowDialog',
    //   component: () => import('./components/flow_dialog.vue')
    // }
  ]
})
