package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.CookieProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.web.commons.utils.RequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.function.Supplier;

@Component
public class CookieProviderImpl implements CookieProvider {
    private static final Logger logger = LoggerFactory.getLogger(CookieProviderImpl.class);
    private final HttpServletResponse response;
    private final HttpServletRequest request;
    private final JsonProvider jsonProvider;
    public CookieProviderImpl(HttpServletResponse response,
                              HttpServletRequest request,
                              JsonProvider jsonProvider) {
        this.response = response;
        this.request = request;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void add(String name, String value) {
        String cookieValue = value;
        Cookie cookie = new Cookie(name, cookieValue);
        cookie.setPath("/");
        cookie.setMaxAge(7200);
        this.response.addCookie(cookie);
    }

    @Override
    public String get(String name) {
        return RequestUtil.getCookieValue(request,name);
    }

    @Override
    public <T> T get(Class<T> tClass, String name, Supplier<T> supplier) {
        assert supplier != null;
        return supplier.get();
        /*
        assert supplier != null;
        T data = null;
        try {
            String value = RequestUtil.getCookieValue(request, name);
            data = this.jsonProvider.getData(value, tClass);
        } catch (Exception ex) {
            //logger.error(String.format("获取Cookie数据(%s)失败", name), ex);
            ex.printStackTrace();
        }

        if (data == null) {
            data = supplier.get();
            try {
                RequestUtil.setCookieValue(response, name, this.jsonProvider.getJson(data));
            } catch (Exception ex) {
                //logger.error("获取Cookie数据异常", ex);
                ex.printStackTrace();
            }
        }

        return data;

         */
    }
}
