package com.bcxin.web.commons;

import com.bcxin.saas.core.utils.ComponentUtils;
import com.bcxin.web.commons.filters.BasicWebFilter;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Configuration("com.bcxin.web.commons.SetupConfig")
@ComponentScan(basePackages = "com.bcxin.web.commons")
public class SetupConfig implements WebMvcConfigurer {

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    public RequestHandlerInterceptor requestHandlerInterceptor() {
        return new RequestHandlerInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        WebMvcConfigurer.super.addInterceptors(registry);
        registry.addInterceptor(requestHandlerInterceptor())
                .addPathPatterns("/api/runtime/**","/api/runtime-ex/**");
    }

    @Bean
    public FilterRegistrationBean<BasicWebFilter> registerBasicWebFilter() {
        FilterRegistrationBean<BasicWebFilter> bean = new FilterRegistrationBean<BasicWebFilter>();
        bean.setFilter(new BasicWebFilter());//注册自定义过滤器
        bean.setName("BasicWebFilter");//过滤器名称
        bean.addUrlPatterns("/*");//过滤所有路径

        bean.addInitParameter("exclusions", ComponentUtils.getExclusions());
        bean.setOrder(1);//优先级，最顶级

        return bean;
    }

    @Bean
    public RedissonClient redissonClient(RedisProperties redisProperties) {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();


        //可以redisss://用来启动SSL
        singleServerConfig.setAddress(String.format("redis://%s:%s", redisProperties.getHost(), redisProperties.getPort()));
        singleServerConfig.setPassword(redisProperties.getPassword());
        singleServerConfig.setConnectionPoolSize(10000);
        singleServerConfig.setPingConnectionInterval(10000);

        RedissonClient redissonClient = Redisson.create(config);

        return redissonClient;
    }

    @Bean
    public WebMvcRegistrations webMvcRegistrations() {
        return new WebMvcRegistrations() {
            @Override
            public ExceptionHandlerExceptionResolver getExceptionHandlerExceptionResolver() {
                return new ExceptionHandlerExceptionResolver(){
                    @Override
                    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception exception) {
                        return super.doResolveHandlerMethodException(request, response, handlerMethod, exception);
                    }
                };
            }
        };
    }
}
