package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.SecondCacheProvider;
import com.bcxin.saas.core.components.ThreadContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import java.util.function.Supplier;

@Component
@Primary
public class SecondCacheProviderRequestAttributeImpl implements SecondCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecondCacheProviderRequestAttributeImpl.class);
    private final ThreadContextManager threadContextManager;

    public SecondCacheProviderRequestAttributeImpl(ThreadContextManager threadContextManager) {
        this.threadContextManager = threadContextManager;
    }

    @Override
    public <T> T getData(String key, Supplier<T> supplier) {
        Object result = threadContextManager.get(key);

        if (result == null) {
            result = supplier.get();
            threadContextManager.store(key, result);
        }

        return (T) result;
    }

    @Override
    public void removeData(String key) {
        threadContextManager.remove(key);
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T) threadContextManager.get(key);
    }

    @Override
    public <T> void setData(String key, T data) {
        threadContextManager.store(key, data);
    }

    @Override
    public boolean isWebRequest() {
        try {
            return threadContextManager.isWebRequest();
        } catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void clear() {
        try {
            this.threadContextManager.clear();
        }
        catch (Exception ex) {
            logger.error("clear 发生异常", ex);
        }
        /*
        changed by 20231106 复用线程
        try {
            this._currentThreadContainer.set(null);
        } catch (Exception ex) {
            logger.error("{}: 清除当前请求中的键值失败", new Date());
            ex.printStackTrace();
        }
         */
    }
}
