package cn.myapps.versions.action;

import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.versions.service.VersionsService;
import net.sf.json.JSONObject;

/**
 * Created by ZhanBo-ZJB on 2017/10/20.
 */
public class VersionsAct {

    private VersionsService versionsService;
    
    public VersionsAct() throws Exception {
        versionsService = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
    }

    /**
     * 版本迁移至文件系统
     * {
     * 	 "status" : 迁移是否成功 ： true / false
     *   "message"：  迁移提示信息
     *
     *        2000 : 迁移成功
     *        4001 : workspace下已经存在数据
     *        4002 : 存在脏数据，无法迁移
     *
     *   "datas":   具体数字信息
     * }
     *
     * @return
     */
    public String doUpgrade(){
        String result = null ;
        try {
            result = (versionsService).doUpgrade2FileSystem();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }

    public String doClear(){

        String result = null ;
        try {
            result = versionsService.doClearFileSystem();
            return result;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }
    
    public String doTransData() {
    	String result = null ;
        try {
            result = (versionsService).doUpgradeData();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }

    public String isUpgradeSuccess(){
        JSONObject result = new JSONObject();
        try {
            boolean flag = (versionsService.isUpgradeSuccess());
            result.put("status", true);
            result.put("message", null);
            result.put("datas", flag);
        } catch (Exception e) {
            e.printStackTrace();
            result.put("status", false);
            result.put("message", e.getMessage());
            result.put("datas", null);
        }
        return result.toString();
    }

}
