package cn.myapps.upgrade.gui;

import cn.myapps.run.Start;
import cn.myapps.versions.action.VersionsAct;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Launcher {

	public Launcher() throws Exception {
		JFrame jf = new JFrame("转换器");
		jf.setSize(750, 480);
		jf.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		jf.setLocationRelativeTo(null);

		// 创建选项卡面板
		final JTabbedPane tabbedPane = new JTabbedPane();

		tabbedPane.addTab("转换", createModulePanel());

		// 添加选项卡选中状态改变的监听器
		tabbedPane.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
			}
		});

		// 设置默认选中的选项卡
		tabbedPane.setSelectedIndex(0);

		jf.setContentPane(tabbedPane);
		jf.setVisible(true);
	}

	public static void main(String[] args) throws Exception {
		new Launcher();
	}

	// 模块面板
	private JComponent createModulePanel()
			throws Exception {

		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout(20, 10));

		JPanel bar = new JPanel();
		JLabel label = new JLabel("启动中...");
		panel.add(bar, java.awt.BorderLayout.NORTH);
		bar.add(label);
		JButton btnStart = new JButton("转换模板[M3#1.6 -> 4.4]");
		bar.add(btnStart);
		btnStart.setEnabled(false);

		JButton btnRemove = new JButton("删除已转模板");
		bar.add(btnRemove);
		btnRemove.setEnabled(false);

		JButton btnData = new JButton("转换数据[4.4->5.0]");
		bar.add(btnData);
		btnData.setEnabled(false);

		JButton btnClean = new JButton("清空控制台");
		bar.add(btnClean);

		ConsoleTextArea console = new ConsoleTextArea();
		panel.add(console);
		console.setEditable(false);
//		console.setEnabled(false);
		console.setFocusable(false);
		panel.add(new JScrollPane(console), java.awt.BorderLayout.CENTER);
		btnStart.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				try {
					VersionsAct act = new VersionsAct();
					String message = act.doUpgrade();
					System.out.println(message);
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
		});

		btnRemove.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				try {
					VersionsAct act = new VersionsAct();
					act.doClear();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
		});

		btnData.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				new Thread(new Runnable() {
					@Override
					public void run() {
						try {
							VersionsAct act = new VersionsAct();
							act.doTransData();
						} catch (Exception e1) {
							e1.printStackTrace();
						}
					}
				}).start();;

			}
		});

		btnClean.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				console.setText("");
			}
		});

		new Thread(new Runnable() {
			@Override
			public void run() {
				while(true) {
					try {
						Thread.sleep(1000);
						if (Start.STATUS == 1) {
							btnStart.setEnabled(true);
							btnRemove.setEnabled(true);
							btnData.setEnabled(true);

							label.setText("启动成功！");
							break;
						}
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}).start();

		return panel;
	}

}