package cn.myapps.upgrade.gui;
   
   
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;   
   
public class ConsoleTextArea extends JTextArea {   
    /**
	 * 
	 */
	private static final long serialVersionUID = 8951783929401392050L;
	
	private PipedOutputStream out; 
	private PipedInputStream in;
	private PrintStream ps;


	public ConsoleTextArea() {
		initInputStreams();
    } 
	
	private void initInputStreams() {
		try {
			out = new PipedOutputStream();
			in = new PipedInputStream(out, 1024);
			ps = new PrintStream(out);
			System.setOut(ps);
			System.setErr(ps);
			
		} catch (IOException e) {
			e.printStackTrace();
		}

		
		for (Thread thread : threads) {
			thread.interrupt();
		}
		threads.clear();
//		for(int i = 0; i < inStreams.length; ++i)   
//            startConsoleReaderThread(inStreams[i]);   
		
		startConsoleReaderThread(in);
	}
	
	ArrayList<Thread> threads = new ArrayList<Thread>();
   
    private void startConsoleReaderThread(   
        InputStream inStream) {   
        final BufferedReader br =   
            new BufferedReader(new InputStreamReader(inStream, Charset.forName("UTF-8")));   
        Thread thread = new Thread(new Runnable() {   
            public void run() {   
                StringBuffer sb = new StringBuffer();   
                try {   
                    String s;   
                    Document doc = getDocument();
                    while((s = br.readLine()) != null) {   
                        boolean caretAtEnd = false;   
                        caretAtEnd = getCaretPosition() == doc.getLength() ?   
                            true : false;   
                        sb.setLength(0);
                        //超出10000字符则截取，避免内存占用过大
                        if (doc.getLength() > 10240) {
                        	try {
								doc.remove(0, s.length());
							} catch (BadLocationException e) {
								e.printStackTrace();
							}
                        }
                        
                        append(sb.append(s).append('\n').toString());
                        
                        if(caretAtEnd)   
                            setCaretPosition(doc.getLength());   
                    }   
                }   
                catch(IOException e) {
                	initInputStreams();
                }   
            }   
        });
        threads.add(thread);
        thread.start(); 
    } // startConsoleReaderThread()   
   
} // ConsoleTextArea   


class LoopedStreams {   
    private PipedOutputStream pipedOS = new PipedOutputStream();   
    private boolean keepRunning = true;   
    private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream() {   
        public void close() {   
            keepRunning = false;   
            try {   
                super.close();   
                pipedOS.close();   
            } catch (IOException e) {   
                System.exit(1);   
            }   
        }   
    };   
   
    private PipedInputStream pipedIS = new PipedInputStream() {   
        public void close() {   
            keepRunning = false;   
            try {   
                super.close();   
            } catch (IOException e) {   
                System.exit(1);   
            }   
        }   
    };   
   
    public LoopedStreams() throws IOException {   
        pipedOS.connect(pipedIS);   
        startByteArrayReaderThread();   
    } // LoopedStreams()   
   
    public InputStream getInputStream() {   
        return pipedIS;   
    } // getInputStream()   
   
    public OutputStream getOutputStream() {   
        return byteArrayOS;   
    } // getOutputStream()   
   
    private void startByteArrayReaderThread() {   
        new Thread(new Runnable() {   
            public void run() {   
                while (keepRunning) {   
                    if (byteArrayOS.size() > 0) {   
                        byte[] buffer = null;   
                        synchronized (byteArrayOS) {   
                            buffer = byteArrayOS.toByteArray();   
                            byteArrayOS.reset();   
                        }   
                        try {   
                            pipedOS.write(buffer, 0, buffer.length);   
                        } catch (IOException e) {   
                            System.exit(1);   
                        }   
                    } else   
                        try {   
                            Thread.sleep(1000);   
                        } catch (InterruptedException e) {   
                        }   
                }   
            }   
        }).start();   
    } // startByteArrayReaderThread()   
} // LoopedStreams   