package cn.myapps.upgrade.dao;

import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.upgrade.model.ApplicationDomainSet;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface UpgradeDao {

	/**
	 * 获取软件-企业域Set
	 * @return
	 */
	Collection<ApplicationDomainSet> queryApplicationDomainSets() throws Exception;
	
	/**
	 * 获取软件
	 * @return
	 */
	
	Collection<FileSystemDesignTimeSerializable> queryApplications() throws Exception;
	/**
	 * 获取软件源
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryDataSources() throws Exception;
	/**
	 * 获取模块
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryModules() throws Exception;
	/**
	 * 获取表单
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryForms() throws Exception;
	/**
	 * 获取视图
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryViews() throws Exception;
	/**
	 * 获取摘要
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> querySummarys() throws Exception;
	/**
	 * 获取流程
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryFlows() throws Exception;
	/**
	 * 获取菜单
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryResouces() throws Exception;
	/**
	 * 获取交叉报表
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryCrossReports() throws Exception;
	/**
	 * 获取Excel导入
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryExlcfgs() throws Exception;
	/**
	 * 获取任务
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryTasks() throws Exception;
	/**
	 * 获取widget
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryWidgets() throws Exception;
	/**
	 * 获取状态标签
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryStateLabels() throws Exception;
	/**
	 * 获取套打
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryPrints() throws Exception;
	/**
	 * 获取函数库
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryMacroRepositorys() throws Exception;
	/**
	 * 获取校验库
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryValidRepositorys() throws Exception;
	/**
	 * 获取样式库
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryStyleRepositorys() throws Exception;
	/**
	 * 获取多语言
	 * @return
	 */
	Collection<FileSystemDesignTimeSerializable> queryMulitlangs() throws Exception;

	/**
	 * 获取角色
	 * @return
	 * @throws Exception
	 */
	Collection<FileSystemDesignTimeSerializable> queryRoles() throws Exception;
	
    /**
     * 插入t_user_department_role表
     * @param userId 用户id
     * @param roleId 角色id
     * @param departmentId 部门id
     * @return
     * @throws Exception
     */
    String insertUserDepartmentRoleSet(String userId,String roleId,String departmentId) throws Exception;
    
    /**
     * t_user_role_set关链t_user_depatment_set(为插入t_user_department_role作准备)
     * @param userId 用户id
     * @return
     * @throws Exception
     */
    List<Map<String,String>> listUserIdDeptIdRoleId() throws Exception;
    
    /**
     * 判断表t_user_role_set,t_user_department_set是否存在
     * @return
     * @throws Exception
     */
    boolean isExistUserRoleSetAndUserDeptSet() throws Exception;

	/**
	 * 判断表t_user_role_set,t_user_department_set是否存在
	 * @return
	 * @throws Exception
	 */
	boolean isExistRole() throws Exception;
	/**
	 * 查找外键1.6的t_user_department和t_user_department_set的外键,并删除
	 * @throws Exception
	 */
    void DeleteForeignFromUserDepartmentSetAndUserRoleSet() throws Exception;
}
