package cn.myapps.upgrade.dao;

import cn.myapps.authtime.common.dao.ConnectionManager;
import cn.myapps.common.util.DbUtil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MySqlUpgradeDAO extends AbstractUpgradeDao implements UpgradeDao {

	public MySqlUpgradeDAO(Connection conn) throws Exception {
		super(conn);
		dbTag = "MY SQL: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_MYSQL);
	}

	@Override
	public void DeleteForeignFromUserDepartmentSetAndUserRoleSet() throws Exception {
		List<Map<String,String>> lists=new ArrayList<Map<String,String>>();
		Connection conn=null;
		PreparedStatement stmt=null;
		ResultSet rs =null;
//		PropertyUtil.reload("proxool");
//		String url = PropertyUtil.get("jdbc-0.proxool.driver-url");
//		String databaseName = url.substring(url.lastIndexOf("/")+1, url.lastIndexOf("?"));
		Map<String,String> maps=new HashMap<String,String>();
		try {
			conn= ConnectionManager.getConnection();
			String databaseName = conn.getSchema();
			String sql="SELECT TABLE_NAME,COLUMN_NAME,CONSTRAINT_NAME, REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE CONSTRAINT_SCHEMA ='"+databaseName+"' AND REFERENCED_TABLE_NAME = 'T_USER' AND TABLE_NAME IN ('T_USER_DEPARTMENT_SET','T_USER_ROLE_SET')";
			stmt=conn.prepareStatement(sql);
			rs = stmt.executeQuery();
			//防止此表有多个外键
			while(rs.next()) {
				maps=new HashMap<String,String>();
				maps.put(rs.getString("TABLE_NAME"), rs.getString("CONSTRAINT_NAME"));
				lists.add(maps);
			}
			System.out.println(lists);

			for (Map<String, String> map : lists) {
				//删除外键：
				for (String key:map.keySet()) {
					PreparedStatement deleteForeignPs = null;
					try {
						String deleteForeign = "ALTER TABLE "+key+" DROP FOREIGN KEY "+map.get(key);
						deleteForeignPs = conn.prepareStatement(deleteForeign);
						deleteForeignPs.executeUpdate();
					} catch (Exception e) {
						e.printStackTrace();
					}finally{
						if(deleteForeignPs!=null) deleteForeignPs.close();
					}
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}finally{
			ConnectionManager.closeStatement(stmt);
			if(rs!=null) rs.close();
			if(conn!=null) conn.close();
		}
	}

}
