package cn.myapps.upgrade.dao;

import static cn.myapps.common.model.view.constant.ViewConstant.VIEW_TYPE_TREE;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.crossreport.CrossReportVO;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.multilanguage.MultiLanguage;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.MapView;
import cn.myapps.common.model.view.TreeView;
import cn.myapps.common.model.view.constant.ViewConstant;
import cn.myapps.common.model.view.dto.ViewDirector;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.upgrade.model.ApplicationDomainSet;
import cn.myapps.upgrade.util.ConnectionManager;
import cn.myapps.upgrade.util.ConvertUtil;
import cn.myapps.upgrade.util.LogHelper;
import cn.myapps.upgrade.util.UpgradeConstant;
import net.sf.json.JSONObject;


public abstract class AbstractUpgradeDao implements UpgradeDao {

	private static final Logger log = LoggerFactory.getLogger(AbstractUpgradeDao.class);

	protected String dbTag = "MY SQL: ";
	protected String schema = "";
	protected Connection connection;

	public AbstractUpgradeDao(Connection conn) throws Exception {
		connection = conn;
	}

	@Override
	public Collection<ApplicationDomainSet> queryApplicationDomainSets() throws Exception{
		Collection<ApplicationDomainSet> list = new ArrayList<ApplicationDomainSet>();
		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.APPLICATION_DOMAIN_SET);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			ApplicationDomainSet applicationDomainSet;
			while (rs.next()) {
				applicationDomainSet = new ApplicationDomainSet();
				String domainId = rs.getString("DOMAINID");
				String applicationId = rs.getString("APPLICATIONID");
				applicationDomainSet.setApplicationId(applicationId);
				applicationDomainSet.setDomainId(domainId);
				list.add(applicationDomainSet);
			}
			rs.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryApplications() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.APPLICATION);

		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			Application app;
			while (rs.next()) {
				app = new Application();
				String systemWidgetSetting = rs.getString("SYSTEM_WIDGET_SETTING");
				String datasourceId = rs.getString("DATASOURCEID");
				String description = rs.getString("DESCRIPTION");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				boolean activated = rs.getBoolean("ACTIVATED");
				String name = rs.getString("NAME");
				
				app.setSystemWidgetSetting(systemWidgetSetting);
				app.setDatasourceId(datasourceId);
				app.setDescription(description);
				app.setId(id);
				app.setApplicationid(applicationid);
				app.setActivated(activated);
				setNameByReflect(app,name);
				
				list.add(app);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryDataSources() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.DATASOURCE);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			DataSource ds;
			while (rs.next()) {

				ds = new DataSource();

				String securityCredentials = rs.getString("SECURITYCREDENTIALS");
				int dbType = rs.getInt("DBTYPE");
				String useType = rs.getString("USETYPE");
				String parentId = rs.getString("APPLICATIONID");
				String url = rs.getString("URL");
				String timeout = rs.getString("TIMEOUT");
				String providerUrl = rs.getString("PROVIDERURL");
				String jndiName = rs.getString("JNDINAME");
				String initialContextFactory = rs.getString("CONTEXTFACTORY");
				String password = rs.getString("PASSWORD");
				String poolsize = rs.getString("POOLSIZE");
				String driverClass = rs.getString("DRIVERCLASS");
				String urlPkgPrefixes = rs.getString("URLPKGPREFIXES");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String securityPrincipal = rs.getString("SECURITYPRINCIPAL");
				String username = rs.getString("USERNAME");
				String name = rs.getString("NAME");

				
				ds.setSecurityCredentials(securityCredentials);
				ds.setDbType(dbType);
				ds.setUseType(useType);
				ds.setParentId(parentId);
				ds.setUrl(url);
				ds.setTimeout(timeout);
				ds.setProviderUrl(providerUrl);
				ds.setJndiName(jndiName);
				ds.setInitialContextFactory(initialContextFactory);
				ds.setPassword(password);
				ds.setPoolsize(poolsize);
				ds.setDriverClass(driverClass);
				ds.setUrlPkgPrefixes(urlPkgPrefixes);
				ds.setId(id);
				ds.setApplicationid(applicationid);
				ds.setSecurityPrincipal(securityPrincipal);
				ds.setUsername(username);
				setNameByReflect(ds,name);
				
				if(!vaildate(ds)){
					continue;
				}
				

				list.add(ds);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryModules() throws Exception {
		Collection<FileSystemDesignTimeSerializable> treeList = new ArrayList<FileSystemDesignTimeSerializable>();
		Collection<Module> list = new ArrayList<Module>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.MODULE);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			Module module;
			while (rs.next()) {

				module = new Module();
				String id = rs.getString("ID");
				String description = rs.getString("DESCRIPTION");
				String name = rs.getString("NAME");
				int orderNo = rs.getInt("ORDERNO");
				String superior = rs.getString("SUPERIOR");
				String applicationid = rs.getString("APPLICATION");
				module.setId(id);
				module.setDescription(description);
				module.setOrderNo(orderNo);
				module.setSuperior(superior);
				module.setApplicationid(applicationid);
				setNameByReflect(module,name);
				list.add(module);
			}

			treeList = treeSort(list);
			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return treeList;
	}
	

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryResouces() throws Exception {
		
		Collection<FileSystemDesignTimeSerializable> treeList = new ArrayList<FileSystemDesignTimeSerializable>();
		Collection<ResourceVO> list = new ArrayList<ResourceVO>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.MENU);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			ResourceVO menu;
			while (rs.next()) {
				menu = new ResourceVO();
				String id = rs.getString("ID");
				String name = rs.getString("DESCRIPTION");
				String applicationid = rs.getString("APPLICATIONID");
				String aDescription = rs.getString("DESCRIPTION");
				String multiLanguageLabel = rs.getString("MULTILANGUAGELABEL");
				String aType = rs.getString("TYPE");
				String opentarget = rs.getString("OPENTARGET");
				String ico = rs.getString("ICO");
				String mobileIco = rs.getString("MOBILEICO");
				String superior = rs.getString("SUPERIOR");
				String reportAppliction = rs.getString("REPORTAPPLICTION");
				String reportModule = rs.getString("REPORTMODULE");
				String report = rs.getString("REPORT");
				String linkName = rs.getString("LINKNAME");
				String linkType = rs.getString("LINKTYPE");
				String moduleid = rs.getString("MODULEID");
				String directory = rs.getString("DIRECTORY");
				String actionContent = rs.getString("ACTIONCONTENT");
				String queryString = rs.getString("QUERYSTRING");
				String permissionType = rs.getString("PERMISSION_TYPE");
				String showtotalrow = rs.getString("SHOWTOTALROW");
				int orderno = rs.getInt("SORTNO");
				int showType = rs.getInt("SHOW_TYPE");
				
				menu.setId(id);
				menu.setApplicationid(applicationid);
				menu.setDescription(aDescription);
				menu.setMultiLanguageLabel(multiLanguageLabel);
				menu.setType(aType);
				menu.setOpentarget(opentarget);
				menu.setIco(ico);
				menu.setMobileIco(mobileIco);
				menu.setReportAppliction(reportAppliction);
				menu.setReportModule(reportModule);
				menu.setReport(report);
				menu.setLinkName(linkName);
				menu.setLinkType(linkType);
				menu.setModuleid(moduleid);
				menu.setDirectory(directory);
				menu.setActionContent(actionContent);
				menu.setQueryString(queryString);
				menu.setPermissionType(permissionType);
				menu.setShowtotalrow(showtotalrow);
				menu.setOrderno(orderno);
				menu.setShowType(showType);
				menu.setSuperior(superior);
				setNameByReflect(menu,name);
				list.add(menu);
			}
			
			treeList = treeSort(list);
			
			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return treeList;
	}
	
	@Override
	public Collection<FileSystemDesignTimeSerializable> queryForms() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.FORM);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			Form form;
			while (rs.next()) {
				form = new Form();

				String permissionType = rs.getString("PERMISSION_TYPE");
				String discription = rs.getString("DISCRIPTION");
				int orderno = rs.getInt("ORDERNO");
				String isopenablescript = rs.getString("ISOPENABLESCRIPT");
				String iseditablescript = rs.getString("ISEDITABLESCRIPT");
				int type = rs.getInt("TYPE");
				int version = rs.getInt("VERSIONS");
				String parentId = rs.getString("MODULE");
				String sortId = rs.getString("SORTID");
				String name = rs.getString("NAME");
				String mappingStr = rs.getString("MAPPINGSTR");
				String layoutType = rs.getString("LAYOUT_TYPE");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				boolean showLog = rs.getBoolean("SHOWLOG");
				String template = rs.getString("TEMPLATECONTEXT");
				String style = rs.getString("STYLE");
				
				form.setId(id);
				
				form.setParentId(parentId);
				form.setType(type);
				form.setShowLog(showLog);
				form.setVersion(version);
				form.setIseditablescript(iseditablescript);
				form.setIsopenablescript(isopenablescript);
				form.setMappingStr(mappingStr);
				form.setOrderno(orderno);
				form.setPermissionType(permissionType);
				form.setLayoutType(layoutType);
				form.setDescription(discription);
				form.setApplicationid(applicationid);
				form.setSortId(sortId);
				form.setStyleId(style);
				
				//反射添加对应的字段值
				Class<?> clazz = Form.class;
				Field field = clazz.getDeclaredField("templatecontext");
				field.setAccessible(true);
				field.set(form, template);
				
				setNameByReflect(form,name);
				
				if(!vaildate(form)){
					continue;
				}
				
				list.add(form);

				// 获取按钮
				String actXML = rs.getString("ACTIVITYXML");

				//1.6版本升级2.0版本包结构变化
				if(actXML != null){
					actXML = actXML.replaceAll("cn.myapps.core.dynaform.activity.ejb","cn.myapps.common.model.activity");
				}

				if (!StringUtil.isBlank(actXML)) {
					Document document = DocumentHelper.parseText(actXML);
					Element rootElement = document.getRootElement();
					List<Element> actElems = rootElement.elements("cn.myapps.common.model.activity.Activity");
					Activity act;
					for (Element elem : actElems) {
						act = new Activity();
						upGradeAct(act, elem, form.getId(),form.getApplicationid());
						if(!vaildate(act)){
							continue;
						}
						list.add(act);
					}
				}
			}
			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryViews() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.VIEW);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			AbstractView view;
			while (rs.next()) {
				int viewType = rs.getInt("VIEWTYPE");
				view = ViewDirector.construct(viewType);

				String id = rs.getString("ID");
				String name = rs.getString("NAME");
				String parentId = rs.getString("MODULE");
				String applicationid = rs.getString("APPLICATIONID");
				String description = rs.getString("DESCRIPTION");
				int openType = rs.getInt("OPENTYPE");
				boolean isPagination = rs.getBoolean("ISPAGINATION");
				String pagelines = rs.getString("PAGELINES");
				String editMode = rs.getString("EDITMODE");
				boolean showTotalRow = rs.getBoolean("SHOWTOTALROW");
				String relatedForm = rs.getString("RELATEDFORM");
				boolean refresh = rs.getBoolean("REFRESH");
				Date lastmodifytime = rs.getDate("LASTMODIFYTIME");
				Boolean isroute = rs.getBoolean("ISROUTE");
				String permissionType = rs.getString("PERMISSION_TYPE");
				String searchFormId = rs.getString("FORM_ID");
				String relatedMap = rs.getString("RELATEDMAP");
				String nodeLinkId = rs.getString("NODELINKID");
				String country = rs.getString("COUNTRY");
				String province = rs.getString("PROVINCE");
				String city = rs.getString("CITY");
				String town = rs.getString("TOWN");
				String level = rs.getString("MAP_LEVEL");
				String authorityCondition = rs.getString("AUTHORITYCONDITION");
				String relatedResourceid = rs.getString("RELATEDRESOURCEID");
				String templateForm = rs.getString("TEMPLATEFORM");
				String orderField = rs.getString("ORDERFIELD");
				String orderType = rs.getString("ORDERTYPE");
				String auth_user = rs.getString("AUTH_USER");
				String auth_role = rs.getString("AUTH_ROLE");
				String auth_fields = rs.getString("AUTH_FIELDS");
				String authFieldScope = rs.getString("AUTHFIELD_SCOPE");
				Boolean readonly = rs.getBoolean("READONLY");
				String relationDateColum = rs.getString("RELATIONDATECOLUM");
				String innerType = rs.getString("INNERTYPE");
				String displayType = rs.getString("DISPLAYTYPE");
				boolean pagination = rs.getBoolean("ISPAGINATION");
				String commonFilterCondition = rs.getString("COMMON_FILTER_CONDITION");
				String sqlFilterScript = rs.getString("SQLFILTER_SCRIPT");

				String filterScript = rs.getString("FILTER_SCRIPT");

				String departments = rs.getString("DEPARTMENTS");
				String procedureFilterScript = rs.getString("PROCEDUREFILTER_SCRIPT");
				String filterCondition = rs.getString("FILTERCONDITION");
				view.setSqlFilterScript(sqlFilterScript);
				view.setProcedureFilterScript(procedureFilterScript);
				view.setFilterCondition(filterCondition);
				view.setDepartments(departments);
				view.setPagination(pagination);
				view.setCommonFilterCondition(commonFilterCondition);
				view.setFilterScript(filterScript);
				view.setId(id);
				
				view.setParentId(parentId);
				view.setApplicationid(applicationid);
				view.setDescription(description);
				view.setOpenType(openType);
				view.setPagination(isPagination);
				view.setPageLines(pagelines);
				view.setEditMode(editMode);
				view.setShowTotalRow(showTotalRow);
				view.setRelatedForm(relatedForm);
				view.setRefresh(refresh);
				view.setLastModifyTime(lastmodifytime);
				if(view.getViewTypeImpl().intValue() == ViewConstant.VIEW_TYPE_MAP) {
					MapView mapView = (MapView) view;
					mapView.setIsRoute(isroute);
				}
				view.setPermissionType(permissionType);
				view.setSearchFormId(searchFormId);
				view.setRelatedResourceId(relatedResourceid);
				view.setTemplateForm(templateForm);
				view.setOrderField(orderField);
				view.setOrderType(orderType);
				view.setAuth_user(auth_user);
				view.setAuth_role(auth_role);
				view.setAuth_fields(auth_fields);
				view.setAuthFieldScope(authFieldScope);
				view.setDepartments(departments);
				view.setReadonly(readonly);
				view.setRelatedMap(relatedMap);
				if(viewType == VIEW_TYPE_TREE) {
					TreeView treeView = (TreeView) view;

					treeView.setNodeLinkId(nodeLinkId);
					treeView.setInnerType(innerType);
				}
				if(view.getViewTypeImpl().intValue() == ViewConstant.VIEW_TYPE_MAP) {
					MapView mapView = (MapView) view;
					mapView.setCountry(country);
					mapView.setProvince(province);
					mapView.setCity(city);
					mapView.setTown(town);
					mapView.setLevel(level);
				}
				view.setAuthorityCondition(authorityCondition);
				view.setDisplayType(displayType);
				view.setPermissionType(permissionType);

				// 获取链接 当view对象为树形视图
				if(view instanceof TreeView) {
					upGradeLink((TreeView) view, nodeLinkId);
				}
				
				setNameByReflect(view,name);
				
				if(!vaildate(view)){
					continue;
				}
				
				list.add(view);

				// 获取按钮
				String actXML = rs.getString("ACTIVITYXML");

				//1.6版本升级2.0版本包结构变化
				if(actXML != null){
					actXML = actXML.replaceAll("cn.myapps.core.dynaform.activity.ejb","cn.myapps.common.model.activity");
				}

				if (!StringUtil.isBlank(actXML)) {
					Document document = DocumentHelper.parseText(actXML);
					Element rootElement = document.getRootElement();
					List<Element> actElems = rootElement.elements("cn.myapps.common.model.activity.Activity");
					Activity act;
					for (Element elem : actElems) {
						act = new Activity();
						upGradeAct(act, elem, view.getId(),view.getApplicationid());
						
						if(!vaildate(act)){
							continue;
						}
						
						list.add(act);
					}
				}

				// 获取列
				String columnXML = rs.getString("COLUMNXML");

				//1.6版本升级2.0版本包结构变化
				if(columnXML != null){
					columnXML = columnXML.replaceAll("cn.myapps.core.dynaform.view.ejb","cn.myapps.common.model.view");
				}

				if (!StringUtil.isBlank(columnXML)) {
					Document document = DocumentHelper.parseText(columnXML);
					Element rootElement = document.getRootElement();
					List<Element> actElems = rootElement.elements("cn.myapps.common.model.view.Column");
					Column col;
					for (Element elem : actElems) {
						col = new Column();
						upGradeCol(col, elem, view.getId(),view.getApplicationid());
						
						if(!vaildate(col)){
							continue;
						}
						
						list.add(col);
					}
				}
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> querySummarys() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.SUMMARY);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			SummaryCfgVO summary;
			while (rs.next()) {
				summary = new SummaryCfgVO();

				String id = rs.getString("ID");
				String name = rs.getString("TITLE");
				String parentId = rs.getString("FORMID");
				String applicationid = rs.getString("APPLICATIONID");
				
				String title = rs.getString("TITLE");
				String type = rs.getString("TYPE");
				String formId = rs.getString("FORMID");
				String fieldNames = rs.getString("FIELDNAMES");
				int scope = rs.getInt("SCOPE");
				String summaryScript = rs.getString("SUMMARYSCRIPT");

				summary.setId(id);
				
				summary.setParentId(parentId);
				summary.setApplicationid(applicationid);
				summary.setTitle(title);
				summary.setType(type);
				summary.setFormId(formId);
				summary.setFieldNames(fieldNames);
				summary.setScope(scope);
				summary.setSummaryScript(summaryScript);
				
				setNameByReflect(summary,name);
				
				if(!vaildate(summary)){
					continue;
				}
				

				list.add(summary);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryFlows() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.FLOW);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			BillDefiVO bv;
			while (rs.next()) {
				bv = new BillDefiVO();

				String authorno = rs.getString("AUTHORNO");
				String subject = rs.getString("SUBJECT");
				String authorname = rs.getString("AUTHORNAME");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String parentId = rs.getString("MODULE");
				String flow = rs.getString("FLOW");
				Date lastmodify = rs.getDate("LASTMODIFY");
				bv.setAuthorno(authorno);
				bv.setSubject(subject);
				bv.setAuthorname(authorname);
				bv.setId(id);
				bv.setApplicationid(applicationid);
				bv.setParentId(parentId);
				bv.setFlow(flow);
				bv.setLastmodify(lastmodify);
				
				setNameByReflect(bv,subject);
				
				if(!vaildate(bv)){
					continue;
				}
				list.add(bv);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;

	}

	


	@Override
	public Collection<FileSystemDesignTimeSerializable> queryCrossReports() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.CROSS_REPORT);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			CrossReportVO cr;
			while (rs.next()) {
				cr = new CrossReportVO();

				String applicationid = rs.getString("APPLICATIONID");
				String calculationMethod = rs.getString("CALCULATIONMETHOD");
				String colCalMethod = rs.getString("COLCALMETHOD");
				String columns = rs.getString("COLUMNSTR");
				String datas = rs.getString("DATASTR");
				boolean displayCol = rs.getBoolean("ISDISPLAYCOL");
				String id = rs.getString("ID");
				String json = rs.getString("JSON");
				String name = rs.getString("NAME");
				String note = rs.getString("NOTE");
				
				String parentId = rs.getString("MODULE");
				
				
				String reportTitle = rs.getString("REPORTTITLE");
				String rowCalMethod = rs.getString("ROWCALMETHOD");
				String rows = rs.getString("ROWSTR");
				String type = rs.getString("TYPE");
				String userid = rs.getString("USERID");
				String view = rs.getString("VIEWNAME");
				boolean displayRow = rs.getBoolean("ISDISPLAYROW");

				cr.setApplicationid(applicationid);
				cr.setCalculationMethod(calculationMethod);
				cr.setColCalMethod(colCalMethod);
				cr.setColumns(columns);
				cr.setDatas(datas);
				cr.setDisplayCol(displayCol);
				cr.setId(id);
				cr.setJson(json);
				
				cr.setNote(note);
				cr.setParentId(parentId);
				cr.setReportTitle(reportTitle);
				cr.setRowCalMethod(rowCalMethod);
				cr.setRows(rows);
				cr.setType(type);
				cr.setUserid(userid);
				cr.setView(view);
				cr.setDisplayRow(displayRow);
				
				setNameByReflect(cr,name);
				
				if(!vaildate(cr)){
					continue;
				}
				

				list.add(cr);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryExlcfgs() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.EXCEL);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			IMPMappingConfigVO imp;
			while (rs.next()) {
				imp = new IMPMappingConfigVO();

				String xml = rs.getString("XML");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String parentId = rs.getString("APPLICATIONID");
				String templatePath = rs.getString("PATH");
				String name = rs.getString("NAME");

				//2.0版本包结构变化
				if( xml != null ){
					xml = xml.replaceAll("cn.myapps.core.dynaform.dts.excelimport","cn.myapps.runtime.dynaform.dts.excelimport");
				}
				
				imp.setXml(xml);
			
				imp.setId(id);
				imp.setApplicationid(applicationid);
				imp.setParentId(parentId);
				imp.setTemplatePath(templatePath);

				setNameByReflect(imp,name);
				if(!vaildate(imp)){
					continue;
				}
				
				list.add(imp);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryTasks() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.TASK);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			Task task;

			

			while (rs.next()) {
				task = new Task();
				
				int period = rs.getInt("PERIOD");
				String applicationid = rs.getString("APPLICATIONID");
				String creator = rs.getString("CREATOR");
				String creatorid = rs.getString("CREATORID");
				int dayOfMonth = rs.getInt("DAYOFMONTH");
				String description = rs.getString("DESCRIPTION");
				int frequency = rs.getInt("FREQUENCY");
				String id = rs.getString("ID");
				Date modifyTime = rs.getDate("MODIFY_TIME");
				String parentId = rs.getString("APPLICATIONID");
				int type = rs.getInt("TYPE");
				int totalRuntimes = rs.getInt("TOTAL_RUNTIMES");
				String terminateScript = rs.getString("TERMINATE_SCRIPT");
				int state = rs.getInt("STATE");
				String taskScript = rs.getString("TASK_SCRIPT");
				int startupType = rs.getInt("STARTUPTYPE");
				int runtimes = rs.getInt("RUNTIMES");
				Date runningTime = rs.getDate("RUNNINGTIME");
				int repeatTimes = rs.getInt("REPEATTIMES");
				String name = rs.getString("NAME");
				
				
		
				
				// TODO bugs?
				//int executedCount = rs.getInt("executedCount");

				// TODO bugs?
				
				/*
				 * Collection<int> daysOfWeek = rs.getString("ID"); int
				 * executedCount = rs.getInt("ID");
				 * 
				 * task.setDaysOfWeek(daysOfWeek);
				 * task.setExecutedCount(executedCount);
				 */

				task.setModifyTime(modifyTime);
				
				task.setPeriod(period);
				task.setApplicationid(applicationid);
				task.setCreator(creator);
				task.setCreatorid(creatorid);
				task.setDayOfMonth(dayOfMonth);
				task.setDescription(description);
				task.setFrequency(frequency);
				task.setId(id);
				task.setParentId(parentId);
				task.setType(type);
				task.setTotalRuntimes(totalRuntimes);
				task.setTerminateScript(terminateScript);
				task.setState(state);
				task.setTaskScript(taskScript);
				task.setStartupType(startupType);
				task.setRuntimes(runtimes);
				task.setRunningTime(runningTime);
				task.setRepeatTimes(repeatTimes);
				
				setNameByReflect(task,name);
				
				if(!vaildate(task)){
					continue;
				}
				
				

				list.add(task);
			}
			
			rs.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryWidgets() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.WIDGE);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			PageWidget widget;
			while (rs.next()) {
				widget = new PageWidget();

				String titleBColor = rs.getString("TITLE_BCOLOR");
				int orderno = rs.getInt("ORDERNO");
				String icon = rs.getString("ICON");
				String description = rs.getString("DESCRIPTION");
				boolean published = rs.getBoolean("PUBLISHED");
				String type = rs.getString("TYPE");
				String queryString = rs.getString("QUERYSTRING");
				String parentId = rs.getString("APPLICATIONID");
				String authRolesName = rs.getString("AUTH_ROLES_NAME");
				int widgetType = rs.getInt("WIDGET_TYPE");
				String authRolesId = rs.getString("AUTH_ROLES_ID");
				int authMode = rs.getInt("AUTH_MODE");
				String titleColor = rs.getString("TITLE_COLOR");
				String actionContent = rs.getString("ACTIONCONTENT");
				boolean iconShow = rs.getBoolean("ICONSHOW");
				String width = rs.getString("WIDTH");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String moduleid = rs.getString("MODULEID");
				String height = rs.getString("HEIGHT");
				String name = rs.getString("NAME");
				
				
				widget.setTitleBColor(titleBColor);
				widget.setOrderno(orderno);
				widget.setIcon(icon);
				widget.setDescription(description);
				widget.setPublished(published);
				widget.setType(type);
				widget.setQueryString(queryString);
				widget.setParentId(parentId);
				widget.setAuthRolesName(authRolesName);
				widget.setWidgetType(widgetType);
				widget.setAuthRolesId(authRolesId);
				widget.setAuthMode(authMode);
				widget.setTitleColor(titleColor);
				widget.setActionContent(actionContent);
				widget.setIconShow(iconShow);
				widget.setWidth(width);
				widget.setId(id);
				widget.setApplicationid(applicationid);
				widget.setModuleid(moduleid);
				widget.setHeight(height);
				
				setNameByReflect(widget,name);
				if(!vaildate(widget)){
					continue;
				}
				

				list.add(widget);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryStateLabels() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.STATELABEL);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			StateLabel stl;
			while (rs.next()) {
				stl = new StateLabel();

				String description = rs.getString("DESCRIPTION");
				String orderNo = rs.getString("ORDERNO");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String value = rs.getString("VALUE");
				String parentId = rs.getString("APPLICATIONID");
				String name = rs.getString("NAME");
				
				
				
				stl.setDescription(description);
				stl.setOrderNo(orderNo);
				stl.setId(id);
				stl.setApplicationid(applicationid);
				stl.setValue(value);
				stl.setParentId(parentId);
				
				setNameByReflect(stl,name);
				
				if(!vaildate(stl)){
					continue;
				}
				

				list.add(stl);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryPrints() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.PRINT);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			Report print;
			while (rs.next()) {
				print = new Report();

				String template = rs.getString("TEMPLATE");
				String description = rs.getString("DESCRIPTION");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				String parentId = rs.getString("APPLICATIONID");
				String relatedForm = rs.getString("RELATEDFORM");
				String name = rs.getString("NAME");
				
				
				print.setXmlTemplate(template);
				print.setDescription(description);
				print.setId(id);
				print.setApplicationid(applicationid);
				print.setParentId(parentId);
				print.setDataSourceView(relatedForm);
				
				setNameByReflect(print,name);
				
				if(!vaildate(print)){
					continue;
				}
				

				list.add(print);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryMacroRepositorys() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.MACRO_REPOSITORY);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();
			RepositoryVO macro;
			while (rs.next()) {

				macro = new RepositoryVO();
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				int version = rs.getInt("VERSIONS");
				String parentId = rs.getString("APPLICATIONID");
				String content = rs.getString("CONTENT");
				String name = rs.getString("NAME");
			
				macro.setId(id);
				macro.setApplicationid(applicationid);
				macro.setVersion(version);
				macro.setParentId(parentId);
				macro.setContent(content);
				
				
				setNameByReflect(macro,name);
				
				if(!vaildate(macro)){
					continue;
				}
				
				
				
				list.add(macro);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryValidRepositorys() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.VALID_REPOSITORY);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			ValidateRepositoryVO vrv;
			while (rs.next()) {

				vrv = new ValidateRepositoryVO();

				Date lastmodifytime = rs.getDate("LASTMODIFYTIME");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				int version = rs.getInt("VERSIONS");
				String parentId = rs.getString("APPLICATIONID");
				String content = rs.getString("CONTENT");
				String name = rs.getString("NAME");
				
				
				vrv.setLastmodifytime(lastmodifytime);
				vrv.setId(id);
				vrv.setApplicationid(applicationid);
				vrv.setVersion(version);
				vrv.setParentId(parentId);
				vrv.setContent(content);
				
				setNameByReflect(vrv,name);
				if(!vaildate(vrv)){
					continue;
				}
				

				list.add(vrv);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryStyleRepositorys() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.STYLE_REPOSITORY);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			StyleRepositoryVO srv;
			while (rs.next()) {
				srv = new StyleRepositoryVO();

				Date lastmodifytime = rs.getDate("LASTMODIFYTIME");
				String id = rs.getString("ID");
				String applicationid = rs.getString("APPLICATIONID");
				int version = rs.getInt("VERSIONS");
				String parentId = rs.getString("APPLICATIONID");
				String content = rs.getString("CONTENT");
				String name = rs.getString("NAME");
				
				
				srv.setLastmodifytime(lastmodifytime);
				srv.setId(id);
				srv.setApplicationid(applicationid);
				srv.setVersion(version);
				srv.setParentId(parentId);
				srv.setContent(content);
				
				setNameByReflect(srv,name);
				if(!vaildate(srv)){
					continue;
				}
				

				list.add(srv);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryMulitlangs() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.MULTILANG);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			MultiLanguage mulitiLan;

			while (rs.next()) {

				mulitiLan = new MultiLanguage();

				String id = rs.getString("ID");
				String label = rs.getString("LABEL");
				String text = rs.getString("TEXT");
				String applicationid = rs.getString("APPLICATIONID");
				int type = rs.getInt("TYPE");
				String parentId = rs.getString("APPLICATIONID");
				
				mulitiLan.setId(id);
				mulitiLan.setLabel(label);
				mulitiLan.setText(text);
				mulitiLan.setApplicationid(applicationid);
				mulitiLan.setType(type);
				mulitiLan.setParentId(parentId);
				setNameByReflect(mulitiLan,text);
				
				if(!vaildate(mulitiLan)){
					continue;
				}

				list.add(mulitiLan);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	@Override
	public Collection<FileSystemDesignTimeSerializable> queryRoles() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = new ArrayList<FileSystemDesignTimeSerializable>();

		PreparedStatement stmt = null;
		String sql = getSQL(UpgradeConstant.ROLE);
		log.info(sql);
		try {
			stmt = connection.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery();

			Role role;

			while (rs.next()) {

				role = new Role();

				String id = rs.getString("ID");
				String name = rs.getString("NAME");
				String sortId = rs.getString("SORTID");
				String roleNo = rs.getString("ROLENO");
				String applicationId = rs.getString("APPLICATIONID");
				Boolean defaultRole = rs.getBoolean("DEFAULTROLE");
				String parentId = rs.getString("APPLICATIONID");

				role.setId(id);
				role.setName(name);
				role.setSortId(sortId);
				role.setApplicationid(applicationId);
				role.setDefaultRole(defaultRole);
				role.setParentId(parentId);
				setNameByReflect(role,name);

				if(!vaildate(role)){
					continue;
				}

				list.add(role);
			}

			rs.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return list;
	}

	/**
	 * 迁移按钮
	 * 
	 * @param act
	 * @param elem
	 * @param appId 
	 */
	private void upGradeAct(Activity act, Element elem, String parentId, String appId) {

		act.setApplicationid(appId);
		act.setParentId(parentId);
		
		Element jumpTypeElem = elem.element("jumpType");
		if (jumpTypeElem != null) {
			int jumpType = 0;
			jumpType = ConvertUtil.toInt(elem.element("jumpType").getText());
			act.setJumpType(jumpType);
		}

		Element relatedFormIdElem = elem.element("relatedFormId");
		if (relatedFormIdElem != null) {
			String relatedFormId = null;
			relatedFormId = elem.element("relatedFormId").getText();
			act.setRelatedFormId(relatedFormId);
		}

		Element startFlowScriptElem = elem.element("startFlowScript");
		if (startFlowScriptElem != null) {
			String startFlowScript = null;
			startFlowScript = elem.element("startFlowScript").getText();
			act.setStartFlowScript(startFlowScript);
		}

		Element ordernoElem = elem.element("orderno");
		if (ordernoElem != null) {
			int orderno = 0;
			orderno = ConvertUtil.toInt(elem.element("orderno").getText());
			act.setOrderno(orderno);
		}

		Element parentViewElem = elem.element("parentView");
		if (parentViewElem != null) {
			String parentView = null;
			parentView = elem.element("parentView").getText();
			if(!StringUtil.isBlank(parentView)){
				act.setParentView(parentId);
			}
		}

		Element withOldElem = elem.element("withOld");
		if (withOldElem != null) {
			boolean withOld = false;
			withOld = ConvertUtil.toBoolean(elem.element("withOld").getText());
			act.setWithOld(withOld);
		}

		Element showInToolbarElem = elem.element("showInToolbar");
		if (showInToolbarElem != null) {
			boolean showInToolbar = false;
			showInToolbar = ConvertUtil.toBoolean(elem.element("showInToolbar").getText());
			act.setShowInToolbar(showInToolbar);
		}

		Element onActionViewElem = elem.element("onActionView");
		if (onActionViewElem != null) {
			String onActionView = null;
			onActionView = elem.element("onActionView").getText();
			act.setOnActionView(onActionView);
		}

		Element fileNameScriptElem = elem.element("fileNameScript");
		if (fileNameScriptElem != null) {
			String fileNameScript = null;
			fileNameScript = elem.element("fileNameScript").getText();
			act.setFileNameScript(fileNameScript);
		}

		Element iconElem = elem.element("icon");
		if (iconElem != null) {
			String icon = null;
			icon = elem.element("icon").getText();
			act.setIcon(icon);
		}

		Element multiLanguageLabelElem = elem.element("multiLanguageLabel");
		if (multiLanguageLabelElem != null) {
			String multiLanguageLabel = null;
			multiLanguageLabel = elem.element("multiLanguageLabel").getText();
			act.setMultiLanguageLabel(multiLanguageLabel);
		}

		Element expSubElem = elem.element("expSub");
		if (expSubElem != null) {
			boolean expSub = false;
			expSub = ConvertUtil.toBoolean(elem.element("expSub").getText());
			act.setExpSub(expSub);
		}

		Element typeElem = elem.element("type");
		if (typeElem != null) {
			int type = 0;
			type = ConvertUtil.toInt(elem.element("type").getText());
			act.setType(type);
		}

		Element beforeActionScriptElem = elem.element("beforeActionScript");
		if (beforeActionScriptElem != null) {
			String beforeActionScript = null;
			beforeActionScript = elem.element("beforeActionScript").getText();
			act.setBeforeActionScript(beforeActionScript);
		}

		Element impmappingconfigidElem = elem.element("impmappingconfigid");
		if (impmappingconfigidElem != null) {
			String impmappingconfigid = null;
			impmappingconfigid = elem.element("impmappingconfigid").getText();
			act.setImpmappingconfigid(impmappingconfigid);
		}

		Element actionScriptElem = elem.element("actionScript");
		if (actionScriptElem != null) {
			String actionScript = null;
			actionScript = elem.element("actionScript").getText();
			act.setActionScript(actionScript);
		}

		Element onActionPrintElem = elem.element("onActionPrint");
		if (onActionPrintElem != null) {
			String onActionPrint = null;
			onActionPrint = elem.element("onActionPrint").getText();
			act.setOnActionPrint(onActionPrint);
		}

		Element dispatcherModeElem = elem.element("dispatcherMode");
		if (dispatcherModeElem != null) {
			int dispatcherMode = 0;
			dispatcherMode = ConvertUtil.toInt(elem.element("dispatcherMode").getText());
			act.setDispatcherMode(dispatcherMode);
		}

		Element idElem = elem.element("id");
		if (idElem != null) {
			String id = null;
			id = elem.element("id").getText();
			act.setId(id);
		}

		Element readonlyScriptElem = elem.element("readonlyScript");
		if (readonlyScriptElem != null) {
			String readonlyScript = null;
			readonlyScript = elem.element("readonlyScript").getText();
			act.setReadonlyScript(readonlyScript);
		}



		Element afterActionScriptElem = elem.element("afterActionScript");
		if (afterActionScriptElem != null) {
			String afterActionScript = null;
			afterActionScript = elem.element("afterActionScript").getText();
			act.setAfterActionScript(afterActionScript);
		}

		Element transpondElem = elem.element("transpond");
		if (transpondElem != null) {
			String transpond = null;
			transpond = elem.element("transpond").getText();
			act.setTranspond(transpond);
		}

		Element stateToShowElem = elem.element("stateToShow");
		if (stateToShowElem != null) {
			String stateToShow = null;
			stateToShow = elem.element("stateToShow").getText();
			act.setStateToShow(stateToShow);
		}

		Element changeFlowCcElem = elem.element("changeFlowCc");
		if (changeFlowCcElem != null) {
			boolean changeFlowCc = false;
			changeFlowCc = ConvertUtil.toBoolean(elem.element("changeFlowCc").getText());
			act.setChangeFlowCc(changeFlowCc);
		}

		Element onActionFormElem = elem.element("onActionForm");
		if (onActionFormElem != null) {
			String onActionForm = null;
			onActionForm = elem.element("onActionForm").getText();
			act.setOnActionForm(onActionForm);
		}

		Element changeFlowOperatorElem = elem.element("changeFlowOperator");
		if (changeFlowOperatorElem != null) {
			boolean changeFlowOperator = false;
			changeFlowOperator = ConvertUtil.toBoolean(elem.element("changeFlowOperator").getText());
			act.setChangeFlowOperator(changeFlowOperator);
		}

		Element excelNameElem = elem.element("excelName");
		if (excelNameElem != null) {
			String excelName = null;
			excelName = elem.element("excelName").getText();
			act.setExcelName(excelName);
		}

		Element hiddenScriptElem = elem.element("hiddenScript");
		if (hiddenScriptElem != null) {
			String hiddenScript = null;
			hiddenScript = elem.element("hiddenScript").getText();
			act.setHiddenScript(hiddenScript);
		}

		Element workFlowTypeElem = elem.element("workFlowType");
		if (workFlowTypeElem != null) {
			int workFlowType = 0;
			workFlowType = ConvertUtil.toInt(elem.element("workFlowType").getText());
			act.setWorkFlowType(workFlowType);
		}

		Element parentFormElem = elem.element("parentForm");
		if (parentFormElem != null) {
			String parentForm = null;
			parentForm = elem.element("parentForm").getText();
			if(!StringUtil.isBlank(parentForm)){
				act.setParentForm(parentId);
			}
			
		}

		Element dispatcherUrlElem = elem.element("dispatcherUrl");
		if (dispatcherUrlElem != null) {
			String dispatcherUrl = null;
			dispatcherUrl = elem.element("dispatcherUrl").getText();
			act.setDispatcherUrl(dispatcherUrl);
		}

		Element colorTypeElem = elem.element("colorType");
		if (colorTypeElem != null) {
			String colorType = null;
			colorType = elem.element("colorType").getText();
			act.setColorType(colorType);
		}

		Element actionSelectionElem = elem.element("actionSelection");
		if (actionSelectionElem != null) {
			int actionSelection = 0;
			actionSelection = ConvertUtil.toInt(elem.element("actionSelection").getText());
			act.setActionSelection(actionSelection);
		}

		Element actionTypeElem = elem.element("actionType");
		if (actionTypeElem != null) {
			int actionType = 0;
			actionType = ConvertUtil.toInt(elem.element("actionType").getText());
			act.setActionType(actionType);
		}

		Element dispatcherParamsElem = elem.element("dispatcherParams");
		if (dispatcherParamsElem != null) {
			String dispatcherParams = null;
			dispatcherParams = elem.element("dispatcherParams").getText();
			act.setDispatcherParams(dispatcherParams);
		}

		Element jumpActOpenTypeElem = elem.element("jumpActOpenType");
		if (jumpActOpenTypeElem != null) {
			int jumpActOpenType = 0;
			jumpActOpenType = ConvertUtil.toInt(elem.element("jumpActOpenType").getText());
			act.setJumpActOpenType(jumpActOpenType);
		}

		Element targetListElem = elem.element("targetList");
		if (targetListElem != null) {
			String targetList = null;
			targetList = elem.element("targetList").getText();
			act.setTargetList(targetList);
		}

		Element jumpModeElem = elem.element("jumpMode");
		if (jumpModeElem != null) {
			int jumpMode = 0;
			jumpMode = ConvertUtil.toInt(elem.element("jumpMode").getText());
			act.setJumpMode(jumpMode);
		}

		Element contextMenuElem = elem.element("contextMenu");
		if (contextMenuElem != null) {
			boolean contextMenu = false;
			contextMenu = ConvertUtil.toBoolean(elem.element("contextMenu").getText());
			act.setContextMenu(contextMenu);
		}

		Element flowShowTypeElem = elem.element("flowShowType");
		if (flowShowTypeElem != null) {
			String flowShowType = null;
			flowShowType = elem.element("flowShowType").getText();
			act.setFlowShowType(flowShowType);
		}

		Element editModeElem = elem.element("editMode");
		if (editModeElem != null) {
			int editMode = 0;
			editMode = ConvertUtil.toInt(elem.element("editMode").getText());
			act.setEditMode(editMode);
		}

		Element disableFlowNodeElem = elem.element("disableFlowNode");
		if (disableFlowNodeElem != null) {
			boolean disableFlowNode = false;
			disableFlowNode = ConvertUtil.toBoolean(elem.element("disableFlowNode").getText());
			act.setDisableFlowNode(disableFlowNode);
		}

		Element nameElem = elem.element("name");
		if (nameElem != null) {
			String name = null;
			name = elem.element("name").getText();
			setNameByReflect(act,name);
		}

		Element iconurlElem = elem.element("iconurl");
		if (iconurlElem != null) {
			String iconurl = null;
			iconurl = elem.element("iconurl").getText();
			act.setIconurl(iconurl);
		}

		Element onActionFlowElem = elem.element("onActionFlow");
		if (onActionFlowElem != null) {
			String onActionFlow = null;
			onActionFlow = elem.element("onActionFlow").getText();
			act.setOnActionFlow(onActionFlow);
		}

		Element actionDispatcherUrlScriptElem = elem.element("actionDispatcherUrlScript");
		if (actionDispatcherUrlScriptElem != null) {
			String actionDispatcherUrlScript = null;
			actionDispatcherUrlScript = elem.element("actionDispatcherUrlScript").getText();
			act.setActionDispatcherUrlScript(actionDispatcherUrlScript);
		}

	}

	/**
	 * 迁移列
	 *
	 * @param elem
	 * @param appId 
	 */
	private void upGradeCol(Column col, Element elem ,String parentId, String appId) {
		col.setApplicationid(appId);
		col.setParentId(parentId);
		col.setParentView(parentId);
		
		Element formidElem = elem.element("formid");
		if (formidElem != null) {
			String formid = null;
			formid = elem.element("formid").getText();
			col.setFormid(formid);
		}

		Element decimalsCurrElem = elem.element("decimalsCurr");
		if (decimalsCurrElem != null) {
			String decimalsCurr = null;
			decimalsCurr = elem.element("decimalsCurr").getText();
			col.setDecimalsCurr(decimalsCurr);
		}

		Element orderTypeElem = elem.element("orderType");
		if (orderTypeElem != null) {
			String orderType = null;
			orderType = elem.element("orderType").getText();
			col.setOrderType(orderType);
		}

		Element buttonNameElem = elem.element("buttonName");
		if (buttonNameElem != null) {
			String buttonName = null;
			buttonName = elem.element("buttonName").getText();
			col.setButtonName(buttonName);
		}

		Element ordernoElem = elem.element("orderno");
		if (ordernoElem != null) {
			int orderno = 0;
			orderno = ConvertUtil.toInt(elem.element("orderno").getText());
			col.setOrderno(orderno);
		}

		Element formatTypeElem = elem.element("formatType");
		if (formatTypeElem != null) {
			String formatType = null;
			formatType = elem.element("formatType").getText();
			col.setFormatType(formatType);
		}

		Element visible4ExpExcelElem = elem.element("visible4ExpExcel");
		if (visible4ExpExcelElem != null) {
			boolean visible4ExpExcel = false;
			visible4ExpExcel = ConvertUtil.toBoolean(elem.element("visible4ExpExcel").getText());
			col.setVisible4ExpExcel(visible4ExpExcel);
		}

		Element typeElem = elem.element("type");
		if (typeElem != null) {
			String type = null;
			type = elem.element("type").getText();
			col.setType(type);
		}

		Element flowReturnCssElem = elem.element("flowReturnCss");
		if (flowReturnCssElem != null) {
			boolean flowReturnCss = false;
			flowReturnCss = ConvertUtil.toBoolean(elem.element("flowReturnCss").getText());
			col.setFlowReturnCss(flowReturnCss);
		}

		Element templateFormElem = elem.element("templateForm");
		if (templateFormElem != null) {
			String templateForm = null;
			templateForm = elem.element("templateForm").getText();
			col.setTemplateForm(templateForm);
		}

		Element decimalsNumElem = elem.element("decimalsNum");
		if (decimalsNumElem != null) {
			String decimalsNum = null;
			decimalsNum = elem.element("decimalsNum").getText();
			col.setDecimalsNum(decimalsNum);
		}

		Element displayLengthElem = elem.element("displayLength");
		if (displayLengthElem != null) {
			String displayLength = null;
			displayLength = elem.element("displayLength").getText();
			col.setDisplayLength(displayLength);
		}

		Element showTypeElem = elem.element("showType");
		if (showTypeElem != null) {
			String showType = null;
			showType = elem.element("showType").getText();
			col.setShowType(showType);
		}

		Element approveLimitElem = elem.element("approveLimit");
		if (approveLimitElem != null) {
			String approveLimit = null;
			approveLimit = elem.element("approveLimit").getText();
			col.setApproveLimit(approveLimit);
		}

		Element idElem = elem.element("id");
		if (idElem != null) {
			String id = null;
			id = elem.element("id").getText();
			col.setId(id);
		}

		Element imageNameElem = elem.element("imageName");
		if (imageNameElem != null) {
			String imageName = null;
			imageName = elem.element("imageName").getText();
			col.setImageName(imageName);
		}

		Element visibleElem = elem.element("visible");
		if (visibleElem != null) {
			boolean visible = false;
			visible = ConvertUtil.toBoolean(elem.element("visible").getText());
			col.setVisible(visible);
		}

		Element clickSortingElem = elem.element("clickSorting");
		if (clickSortingElem != null) {
			boolean clickSorting = false;
			clickSorting = ConvertUtil.toBoolean(elem.element("clickSorting").getText());
			col.setClickSorting(clickSorting);
		}

		Element displayTypeElem = elem.element("displayType");
		if (displayTypeElem != null) {
			String displayType = null;
			displayType = elem.element("displayType").getText();
			col.setDisplayType(displayType);
		}

		Element visible4PrintElem = elem.element("visible4Print");
		if (visible4PrintElem != null) {
			boolean visible4Print = false;
			visible4Print = ConvertUtil.toBoolean(elem.element("visible4Print").getText());
			col.setVisible4Print(visible4Print);
		}

		Element showTitleElem = elem.element("showTitle");
		if (showTitleElem != null) {
			boolean showTitle = false;
			showTitle = ConvertUtil.toBoolean(elem.element("showTitle").getText());
			col.setShowTitle(showTitle);
		}

		Element nameElem = elem.element("name");
		if (nameElem != null) {
			String name = null;
			name = elem.element("name").getText();
			setNameByReflect(col,name);
		}

		Element mappingformElem = elem.element("mappingform");
		if (mappingformElem != null) {
			String mappingform = null;
			mappingform = elem.element("mappingform").getText();
			col.setMappingform(mappingform);
			;
		}

		Element mappingFieldElem = elem.element("mappingField");
		if (mappingFieldElem != null) {
			String mappingField = null;
			mappingField = elem.element("mappingField").getText();
			col.setMappingField(mappingField);
		}

		Element valueScriptElem = elem.element("valueScript");
		if (valueScriptElem != null) {
			String valueScript = null;
			valueScript = elem.element("valueScript").getText();
			col.setValueScript(valueScript);
		}

		Element fontSizeElem = elem.element("fontSize");
		if (fontSizeElem != null) {
			String fontSize = null;
			fontSize = elem.element("fontSize").getText();
			col.setFontSize(fontSize);
		}

		Element sortStandardElem = elem.element("sortStandard");
		if (sortStandardElem != null) {
			String sortStandard = null;
			sortStandard = elem.element("sortStandard").getText();
			col.setSortStandard(sortStandard);
		}

		Element fieldNameElem = elem.element("fieldName");
		if (fieldNameElem != null) {
			String fieldName = null;
			fieldName = elem.element("fieldName").getText();
			col.setFieldName(fieldName);
		}

		Element colorElem = elem.element("color");
		if (colorElem != null) {
			String color = null;
			color = elem.element("color").getText();
			col.setColor(color);
		}

		Element thouSignElem = elem.element("thouSign");
		if (thouSignElem != null) {
			boolean thouSign = false;
			thouSign = ConvertUtil.toBoolean(elem.element("thouSign").getText());
			col.setThouSign(thouSign);
			;
		}

		Element iconElem = elem.element("icon");
		if (iconElem != null) {
			String icon = null;
			icon = elem.element("icon").getText();
			col.setIcon(icon);
		}

		Element multiLanguageLabelElem = elem.element("multiLanguageLabel");
		if (multiLanguageLabelElem != null) {
			String multiLanguageLabel = null;
			multiLanguageLabel = elem.element("multiLanguageLabel").getText();
			col.setMultiLanguageLabel(multiLanguageLabel);

		}

		Element visible4PagePrintElem = elem.element("visible4PagePrint");
		if (visible4PagePrintElem != null) {
			boolean visible4PagePrint = false;
			visible4PagePrint = ConvertUtil.toBoolean(elem.element("visible4PagePrint").getText());
			col.setVisible4PagePrint(visible4PagePrint);
		}

		Element sumElem = elem.element("sum");
		if (sumElem != null) {
			boolean sum = false;
			sum = ConvertUtil.toBoolean(elem.element("sum").getText());
			col.setSum(sum);
		}

		Element jumpMappingElem = elem.element("jumpMapping");
		if (jumpMappingElem != null) {
			String jumpMapping = null;
			jumpMapping = elem.element("jumpMapping").getText();
			col.setJumpMapping(jumpMapping);
		}

		Element totalElem = elem.element("total");
		if (totalElem != null) {
			boolean total = false;
			total = ConvertUtil.toBoolean(elem.element("total").getText());
			col.setTotal(total);
		}

		Element iconMappingElem = elem.element("iconMapping");
		if (iconMappingElem != null) {
			String iconMapping = null;
			iconMapping = elem.element("iconMapping").getText();
			col.setIconMapping(iconMapping);
		}

		Element buttonTypeElem = elem.element("buttonType");
		if (buttonTypeElem != null) {
			String buttonType = null;
			buttonType = elem.element("buttonType").getText();
			col.setButtonType(buttonType);
		}

		Element actionScriptElem = elem.element("actionScript");
		if (actionScriptElem != null) {
			String actionScript = null;
			actionScript = elem.element("actionScript").getText();
			col.setActionScript(actionScript);
		}

		Element groundColorElem = elem.element("groundColor");
		if (groundColorElem != null) {
			String groundColor = null;
			groundColor = elem.element("groundColor").getText();
			col.setGroundColor(groundColor);
		}

		Element showIconElem = elem.element("showIcon");
		if (showIconElem != null) {
			boolean showIcon = false;
			showIcon = ConvertUtil.toBoolean(elem.element("showIcon").getText());
			col.setShowIcon(showIcon);
		}

		Element currTypeElem = elem.element("currType");
		if (currTypeElem != null) {
			String currType = null;
			currType = elem.element("currType").getText();
			col.setCurrType(currType);
		}

		Element hiddenScriptElem = elem.element("hiddenScript");
		if (hiddenScriptElem != null) {
			String hiddenScript = null;
			hiddenScript = elem.element("hiddenScript").getText();
			col.setHiddenScript(hiddenScript);
		}

		Element widthElem = elem.element("width");
		if (widthElem != null) {
			String width = null;
			width = elem.element("width").getText();
			col.setWidth(width);
		}

		Element isOrderByFieldElem = elem.element("isOrderByField");
		if (isOrderByFieldElem != null) {
			String isOrderByField = null;
			isOrderByField = elem.element("isOrderByField").getText();
			col.setIsOrderByField(isOrderByField);
		}

		Element fontColorElem = elem.element("fontColor");
		if (fontColorElem != null) {
			String fontColor = null;
			fontColor = elem.element("fontColor").getText();
			col.setFontColor(fontColor);
		}

	}

	/**
	 * 迁移视图的树形链接
	 *
	 */
	private void upGradeLink(TreeView view, String nodeLinkId) {
		
		if(!StringUtil.isBlank(nodeLinkId)){
			PreparedStatement stmt = null;
			List<Object> sqlParameters = new ArrayList<Object>();
			String sql = getSQLById("t_link", nodeLinkId,sqlParameters);
			log.info(sql);
			try {
				stmt = connection.prepareStatement(sql);
				cn.myapps.common.dao.JDBCUtil.setParameters(stmt, sqlParameters);
				ResultSet rs = stmt.executeQuery();

				TreeView.LinkVO link ;

				if (rs.next()) {
					link = new TreeView.LinkVO();

					String id = rs.getString("ID");
					String name = rs.getString("NAME");
					String description = rs.getString("description");
					String type = rs.getString("type");
					String moduleid = rs.getString("moduleid");
					String directory = rs.getString("directory");
					String actionContent = rs.getString("actionContent");
					String applicationid = rs.getString("applicationid");
					String queryString = rs.getString("queryString");

					link.setId(id);
					link.setName(name);
					link.setDescription(description);
					link.setType(type);
					link.setModuleId(moduleid);
					link.setDirectory(directory);
					link.setActionContent(actionContent);
					link.setApplicationid(applicationid);
					link.setQueryString(queryString);

					JSONObject linkJSON = JSONObject.fromObject(link);
					view.setLinkVoJson(linkJSON.toString());

				}
				rs.close();
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					ConnectionManager.closeStatement(stmt);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 获取查询数据的SQL语句
	 * 
	 * @param tableName
	 * @return
	 */
	private String getSQL(String tableName) {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT * FROM ").append(this.schema).append(".").append(tableName);
		return sb.toString();

	}

	/**
	 * 获取查询数据的SQL语句
	 * 
	 * @param tableName
	 * @return
	 */
	private String getSQLById(String tableName, String id,List<Object> sqlParameters) {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT * FROM ").append(this.schema).append(".").append(tableName).append(" where ID = ? ");
		sqlParameters.add(id);
		return sb.toString();

	}
	
	/**
	 * 校验数据是否可以被转换
	 * @param file
	 * @return
	 */
	private boolean vaildate(FileSystemDesignTimeSerializable file){
		
		//缓存中是否存在对应的appId :(过滤脏数据)
		boolean isAppIdExist = false ;
		
		String applicationid = file.getApplicationid();
		Object root = DesignTimeSerializableCache.get(applicationid);
			
		if(root != null ){
			isAppIdExist = true ;
		}
		
		if(isAppIdExist == false){
			LogHelper.setError(file, "applicationid不存在", "软件不存在",false);
		}
		
		//是否存在上级数据(除Appliaction外，均有parentId)
		boolean isParentIdExist = false ;
		
		String parentId = file.getParentId();
		if(file instanceof Application){
			isParentIdExist = true ;
		}else{
			if(!StringUtil.isBlank(parentId)){
				isParentIdExist = true ;
			}
		}
		
		if(isParentIdExist == false){
			LogHelper.setError(file, "parentid不存在", "上级不存在", false);
		}
				
		return isAppIdExist && isParentIdExist;
	}
	
	
	/**
	 * 存在层级结构的文件重命名
	 * @param parent
	 * @param list
	 */
	private void reName(FileSystemDesignTimeSerializable parent,Collection list) {
		 String parentName = parent.getName();
		 if(!list.isEmpty()){
			 for(Object obj : list){
				 if(obj instanceof FileSystemDesignTimeSerializable){
					 FileSystemDesignTimeSerializable file = ((FileSystemDesignTimeSerializable) obj);
					 String fileName = file.getName();
					 if(parentName.equalsIgnoreCase(fileName)){
						 setNameByReflect(file,fileName+"_0");
						 break;
					 }
				 }
			 }
		 }
	}
	
	
	/**
	 * 层级结构排序(模块/菜单)
	 * 功能：重新定义parentid
	 * 
	 * @param list
	 * @return
	 */
	private Collection<FileSystemDesignTimeSerializable> treeSort(Collection list) {
		
		List<FileSystemDesignTimeSerializable> Treelist = new ArrayList<FileSystemDesignTimeSerializable>();
		
		Map<String,Collection<FileSystemDesignTimeSerializable>> TreeMap = new HashMap<String,Collection<FileSystemDesignTimeSerializable>>();
		
		for(Object obj : list){
			
			if(obj instanceof FileSystemDesignTimeSerializable){
				
				FileSystemDesignTimeSerializable res = (FileSystemDesignTimeSerializable) obj;
				String superior = null;
				try {
					Class<? extends FileSystemDesignTimeSerializable> clazz = (Class<? extends FileSystemDesignTimeSerializable>) obj.getClass();
					Field field = clazz.getDeclaredField("superior");
					field.setAccessible(true);
					superior = (String) field.get(res);
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				String applicationid = res.getApplicationid();
				if(StringUtil.isBlank(superior)){ //根级菜单
					res.setParentId(applicationid);
					Treelist.add(res);
				}else{
					Collection<FileSystemDesignTimeSerializable> _tmpList = TreeMap.get(superior);
					if(_tmpList == null){
						_tmpList = new ArrayList<FileSystemDesignTimeSerializable>();
					}
					res.setParentId(superior);
					_tmpList.add(res);
					TreeMap.put(superior, _tmpList);
				}
			}
			
			
		}
		
		while(TreeMap.size() > 0){
				Set<String> keySet = TreeMap.keySet();
				c:for(String parentid : keySet){
					for(FileSystemDesignTimeSerializable res : Treelist){
						String id = res.getId();
						if(parentid.equals(id)){
							Collection<FileSystemDesignTimeSerializable> collection = TreeMap.get(id);
							reName(res,collection);
							Treelist.addAll(collection);
							TreeMap.remove(id);
							break c;
						}
					}
				}
		}
		
		Collection<FileSystemDesignTimeSerializable> result = new ArrayList<FileSystemDesignTimeSerializable>();
		
		for(FileSystemDesignTimeSerializable res : Treelist){
			if(!vaildate(res)){
				continue;
			}
			result.add(res);
		}
		return result;
	}
	
	/**
	 * 通过反射设置文件名称
	 */
	private void setNameByReflect(FileSystemDesignTimeSerializable file , String name ){
		if(!StringUtil.isBlank(name)){
		//去除名称中存在的特殊符号
			String regEx="[@#&%]";  
	        Pattern p = Pattern.compile(regEx);  
	        Matcher m = p.matcher(name); 
	        boolean isSpecialSignalExist = m.find();
			if(isSpecialSignalExist){
		        name = m.replaceAll("_");
			}
		
				
				
		Class<? extends FileSystemDesignTimeSerializable> clazz = file.getClass();
		Field field;
		try {
			field = clazz.getSuperclass().getDeclaredField("name");
			field.setAccessible(true);
			field.set(file, name);
		} catch (Exception e) {
			file.setName(name);
		}
	}
	}
	
    /**
     * 插入t_user_department_role表
     * @param userId 用户id
     * @param roleId 角色id
     * @param departmentId 部门id
     * @return
     * @throws Exception
     */
    public String insertUserDepartmentRoleSet(String userId,String roleId,String departmentId) throws Exception{
    	Connection conn=null;
    	PreparedStatement stmt=null;
//    	if(!isExistUserDepartmentRoleSet(userId, roleId, departmentId)){
    		try {
    			conn=ConnectionManager.getConnection();
    			String sql="insert into t_user_department_role_set (ID,DEPARTMENTID,USERID,ROLEID) VALUES(?,?,?,?)";
    			stmt=conn.prepareStatement(sql);
    			stmt.setString(1, UUID.randomUUID().toString());
    			stmt.setString(2, departmentId);
    			stmt.setString(3, userId);
    			stmt.setString(4, roleId);
    			stmt.execute();
    			return "success";
    		} catch(Exception e) {
    			e.printStackTrace();
    		}finally{
    			ConnectionManager.closeStatement(stmt);
    			if(conn!=null) conn.close();
    		}
    	/*}else{
    		return "success";
    	}*/
    	return "success";
    }
    
    public boolean isExistUserDepartmentRoleSet(String userId,String roleId,String departmentId) throws Exception{
    	boolean isExistUserDepartmentRole=false;
    	Connection conn=null;
    	PreparedStatement stmt=null;
//    	List<String> roleIds=null;
    	ResultSet rs =null;
    	try {
//    		roleIds=new ArrayList<String>();
        	conn=ConnectionManager.getConnection();
        	String sql="select * from t_user_department_role_set where USERID=? and ROLEID=? and DEPARTMENTID=?";
        	stmt=conn.prepareStatement(sql);
        	stmt.setString(1, userId);
        	stmt.setString(2, roleId);
        	stmt.setString(3, departmentId);
        	rs = stmt.executeQuery();
        	if (rs.next()) {
        		isExistUserDepartmentRole=true;
    		}
    		rs.close();
		} catch(Exception e) {
			e.printStackTrace();
		}finally{
			ConnectionManager.closeStatement(stmt);
			if(rs!=null) rs.close();
			if(conn!=null) conn.close();
		}
    	return isExistUserDepartmentRole;
    }
    
    /**
     * 判断表t_user_role_set,t_user_department_set是否存在
     * @return
     * @throws Exception
     */
    public boolean isExistUserRoleSetAndUserDeptSet() throws Exception{

    	boolean isExistUserRole=false;
    	boolean isExistUserDept=false;

    	Connection conn=null;
    	PreparedStatement userRoleStmt=null;
    	PreparedStatement userDeptStmt=null;

    	ResultSet userRoleRs =null;
    	ResultSet userDeptRs=null;
    	try {
        	conn=ConnectionManager.getConnection();
        	String sql="show tables like ?";
        	userRoleStmt=conn.prepareStatement(sql);
        	userRoleStmt.setString(1, "t_user_role_set");
        	userRoleRs = userRoleStmt.executeQuery();
        	if (userRoleRs.next()) {
        		isExistUserRole=true;
    		}

        	userDeptStmt=conn.prepareStatement(sql);
        	userDeptStmt.setString(1, "t_user_department_set");
        	userDeptRs=userDeptStmt.executeQuery();
        	if(userDeptRs.next()){
        		isExistUserDept=true;
        	}

		} catch(Exception e) {
			e.printStackTrace();
		}finally{
			if(userRoleStmt!=null) userRoleStmt.close();
			if(userRoleRs!=null) userRoleRs.close();

			if(userDeptStmt!=null) userDeptStmt.close();
			if(userDeptRs!=null) userDeptRs.close();

			if(conn!=null) conn.close();
		}
    	if(isExistUserRole&&isExistUserDept){
    		return true;
    	}
    	return false;

    }

	/**
	 * 判断表t_role是否存在
	 * @return
	 * @throws Exception
	 */
	public boolean isExistRole() throws Exception{

		boolean isExistRoleTable=false;

		Connection conn=null;
		PreparedStatement roleStmt=null;
		ResultSet roleRs =null;
		try {
			conn=ConnectionManager.getConnection();
			String sql="show tables like ?";
			roleStmt=conn.prepareStatement(sql);
			roleStmt.setString(1, "t_role");
			roleRs = roleStmt.executeQuery();
			if (roleRs.next()) {
				isExistRoleTable=true;
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		finally{
			if(roleStmt!=null) roleStmt.close();
			if(roleRs!=null) roleRs.close();
			if(conn!=null) conn.close();
		}
		return isExistRoleTable;
	}
    
    public List<Map<String,String>> listUserIdDeptIdRoleId() throws Exception{
    	List<Map<String,String>> lists=new ArrayList<Map<String,String>>();
    	Connection conn=null;
    	PreparedStatement stmt=null;
    	ResultSet rs =null;
    	
    	Map<String,String> maps=new HashMap<String,String>();
    	try {
        	conn=ConnectionManager.getConnection();
        	String sql="select tu.USERID ,tu.DEPARTMENTID,tur.ROLEID from t_department td join t_user_department_set tu on td.ID=tu.DEPARTMENTID join t_user_role_set tur on tu.USERID=tur.USERID";
        	stmt=conn.prepareStatement(sql);
        	rs = stmt.executeQuery();
        	while(rs.next()) {
        		maps=new HashMap<String,String>();
    			maps.put("userId", rs.getString("USERID"));
    			maps.put("departmentId", rs.getString("DEPARTMENTID"));
    			maps.put("roleId", rs.getString("ROLEID"));
    			lists.add(maps);
    		}
    		rs.close();
		} catch(Exception e) {
			e.printStackTrace();
		}finally{
			ConnectionManager.closeStatement(stmt);
			if(rs!=null) rs.close();
			if(conn!=null) conn.close();
		}
    	return lists;
    }
   
}
