package com.teemlink.qm.util;

import cn.myapps.common.util.StringUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;

import java.util.*;

public class JsonUtil {
	public static Collection<Object> toCollection(String JSONStr) {
		Collection<Object> rtn = new ArrayList<Object>();

		JSONArray array = JSONArray.fromObject(JSONStr);
		for (int i = 0; i < array.size(); i++) {
			Object obj = array.get(i);
			if (obj instanceof JSONObject) {
				rtn.add(toMap((JSONObject) obj));
			} else {
				rtn.add(obj);
			}
		}

		return rtn;
	}

	@SuppressWarnings({ "deprecation", "unchecked" })
	public static Collection<Object> toCollection(String JSONStr, Class<?> objClass) {
		JSONArray array = JSONArray.fromObject(JSONStr);
		List<Object> list = JSONArray.toList(array, objClass);
		return list;
	}

	public static Map<String, Object> toMap(String jsonStr) {
		JSONObject jsonObject = JSONObject.fromObject(jsonStr);
		return toMap(jsonObject);
	}

	private static Map<String, Object> toMap(JSONObject jsonObject) {
		Map<String, Object> rtn = new HashMap<String, Object>();

		if (jsonObject.isNullObject()) {
			return null;
		}
		for (Iterator<?> iterator = jsonObject.keys(); iterator.hasNext();) {
			String key = (String) iterator.next();
			Object obj = jsonObject.get(key);

			if (obj instanceof JSONArray) {
				rtn.put(key, toArray((JSONArray) obj));
			} else if (obj instanceof JSONObject) {
				rtn.put(key, toMap((JSONObject) obj));
			} else if (obj instanceof String) {
				rtn.put(key, StringUtil.dencodeHTML((String)obj));
			}else{
				rtn.put(key, obj);
			}
		}

		return rtn;
	}

	private static Object[] toArray(JSONArray jsonArray) {
		Object[] rtn = new Object[jsonArray.size()];

		for (int i = 0; i < jsonArray.size(); i++) {
			Object obj = jsonArray.get(i);
			if (obj instanceof JSONObject) {
				rtn[i] = toMap((JSONObject) obj);
			} else {
				rtn[i] = obj;
			}
		}

		return rtn;
	}

	public static Object toBean(String jsonStr, Class<?> objClass) {
		JSONObject jsonObject = JSONObject.fromObject(jsonStr);
		Object obj = JSONObject.toBean(jsonObject, objClass);
		return obj;
	}

	public static String collection2Json(Collection<?> collection) {
		return collection2Json(collection, new String[] {});
	}

	public static String collection2Json(Collection<?> collection, String[] excludes) {
		JsonConfig jsonConfig = new JsonConfig();
		JSONArray jsonArray = JSONArray.fromObject(collection, jsonConfig);
		
//		Object[] rtn = new Object[jsonArray.size()];
//		for (int i = 0; i < jsonArray.size(); i++) {
//			Object obj = jsonArray.get(i);
//			if (obj instanceof JSONObject) {
//				rtn[i] = toMap((JSONObject) obj);
//			} else {
//				rtn[i] = obj;
//			}
//		}
		
		return jsonArray.toString();
	}

	public static String toJson(Object obj) {
		JsonConfig config = new JsonConfig();
		
		JSONObject jsonObject = JSONObject.fromObject(obj);
		return jsonObject.toString();
	}

	public static void main(String[] args) throws Exception {
	}
}
