package com.teemlink.qm.util;

/**
 * JSR303的校验帮助类
 * Created by ZhanBo-ZJB on 2017/10/19.
 */

import org.apache.commons.lang.StringUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JSR303Util {

    /**
     * 如果返回null则表示没有错误
     * @param obj
     * @return
     */
    public static List<String> check(Object obj, Set<String> fields) {
        List<String> result = new ArrayList<String>();
        if (null == obj) {
            return result;
        }

        //判断是验证对象部分属性,还是对所有标记验证注解的属性进行验证
        if(fields != null && fields.size() > 0) {
            for(String field: fields) {
                Set<ConstraintViolation<Object>> validResult = Validation.buildDefaultValidatorFactory().getValidator().validateProperty(obj,field);
                for (Iterator<ConstraintViolation<Object>> iterator = validResult.iterator(); iterator.hasNext();) {
                    ConstraintViolation<Object> constraintViolation = iterator.next();
                    if(StringUtils.isNotBlank(constraintViolation.getMessage())) {
                        result.add(constraintViolation.getMessage());
                    } else {
                        result.add("{*[Errors]*}!");
                    }
                }
                return result;
            }
        }else {
            Set<ConstraintViolation<Object>> validResult = null;
            try {
                validResult = Validation.buildDefaultValidatorFactory().getValidator().validate(obj);
            }catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<String>();
            }

            if (null != validResult && validResult.size() > 0) {
                for (Iterator<ConstraintViolation<Object>> iterator = validResult.iterator(); iterator.hasNext();) {
                    ConstraintViolation<Object> constraintViolation = iterator.next();
                    if(StringUtils.isNotBlank(constraintViolation.getMessage())) {
                        result.add(constraintViolation.getMessage());
                    } else {
                        result.add("{*[Errors]*}!");
                    }
                }
                return result;
            }
        }

        return result;
    }

}
