package com.teemlink.qm.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@Component
public class ConnectionManager {
	private final static Logger log = LoggerFactory.getLogger(ConnectionManager.class);

	public static final ThreadLocal<Connection> runtimeDBConn = new ThreadLocal<Connection>();
	
	private static DataSource ds = null;
	
	public static String dbType = "MYSQL";

	@Autowired
	private DataSource dataSource;

	@PostConstruct
	public void init(){
		ds = dataSource;
	}
	
	/**
	 * 获取数据库连接对象
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	public static Connection getConnection() throws Exception {
		Connection threadLocal = runtimeDBConn.get();
		Connection conn = null;
		if (threadLocal != null) {
			conn = threadLocal;
		}
		if (conn == null || conn.isClosed()) {
			conn = newConnection();
			if(conn !=null)
				runtimeDBConn.set(conn);
		}
		
		return conn;
	}
	
	/**
	 * 实例化数据库连接对象
	 * <p>读取“proxool.properties”文件获取obpm系统库的数据源信息，创建数据库连接对象。</p>
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	private static Connection newConnection() throws Exception {
		if(ds != null){
			return ds.getConnection();
		}
		return null;
	}
	
	/**
	 * 关闭Statement
	 * @param stmt
	 * @throws Exception
	 */
	public static void closeStatement(Statement stmt) throws Exception {
		try {
			if (stmt != null) {
				stmt.close();
			}
		} catch (SQLException se) {
			throw new Exception("SQL Exception while closing " + "Statement : \n" + se);
		}
	}
	
	/**
	 * 关闭数据库连接
	 * @throws Exception
	 */
	public static void closeConnection() throws Exception {
		try {
			Connection threadLocal = runtimeDBConn.get();
			if (threadLocal != null) {
					if (!threadLocal.isClosed()) {
						threadLocal.close();
					}
				threadLocal = null;
				
				runtimeDBConn.set(null);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}
	
}
