package com.teemlink.qm.util;

import cn.myapps.common.util.PropertyUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import java.io.*;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CLoader extends ClassLoader {
	private static final Logger log = LoggerFactory
			.getLogger(ClassLoader.class);
	
	public static final String KEY_STORE = "JKS";

	public static final String X509 = "X.509";

	public static final String alias = "www.teemlink.com";

	public static final String password = "helloworld";

	private static Map<String, byte[]> datas = new LinkedHashMap<String, byte[]>();
	
	static CLoader cl;

	static {
		//保证在war卸载后能正常使用Provider
		//解决--非法访问：此Web应用程序实例已停止。无法加载[org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi]
		java.security.Security.addProvider(new BouncyCastleProvider());
		
//		ClassLoader cld = Thread.currentThread().getContextClassLoader();
		ClassLoader cld = CLoader.class.getClassLoader();
		
		log.info("CLoader:" + cld);
//		Thread.currentThread().setContextClassLoader(cld);

		try {
			cl = new CLoader(cld);

			if (datas.size() != 0) {
				for (String zEntry : datas.keySet()) {
					if (zEntry.endsWith(".scz")) {
						cl.loadClass(zEntry);
					}
				}
			} else {
				FileInputStream fis = loadLicenseFile();
				ZipInputStream zis = new ZipInputStream(fis);
				
				try {
					
					ZipEntry zEntry = null;
					do {
						zEntry = zis.getNextEntry();
						if (zEntry != null && zEntry.getName().endsWith(".scz")) {
							cl.loadClass(zEntry.getName());
						}
						
					} while (zEntry != null);
				} finally {
					zis.close();
					fis.close();
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	static public Class<?> init() throws Exception {
		return cl.loadClass("cn.myapps.protection.util.WarpProcessFactory");
	}
	
	static public Class<?> initDesignTimeServiceResolver() throws Exception {
		return cl.loadClass("cn.myapps.protection.util.DesignTimeServiceResolver");
	}
	
	static public Class<?> initRunTimeServiceResolver() throws Exception {
		return cl.loadClass("cn.myapps.protection.util.RunTimeServiceResolver");
	}

	static public Class<?> initSMSSendMode() throws ClassNotFoundException {
		return cl.loadClass("cn.myapps.support.sms.SMSMode");
	}

//	static public Class<?> initReceiveJob() throws ClassNotFoundException {
//		return cl.loadClass("cn.myapps.support.sms.ReceiveJob");
//	}
	
	public static Class<?> initWeixinService() throws ClassNotFoundException {
		return cl.loadClass("cn.myapps.support.weixin.WeixinService");
	}

	private byte[] cerData;

	private CLoader(ClassLoader parent) throws Exception {
		super(parent);
		cerData = readZipEnry("obpm.keystore");
	}

	protected Class<?> findClass(final String name)
			throws ClassNotFoundException {

		try {
			return super.findClass(name);
		} catch (ClassNotFoundException e) {
			if (name != null) {
				try {
					byte[] classData = readZipEnry(name);
					if(classData ==null) return null;
					byte[] decryptData = decryptByPrivateKey(classData,
							new ByteArrayInputStream(cerData));
					
					return defineClass(null, decryptData, 0, decryptData.length);

				} catch (Exception e2) {
					e2.printStackTrace();
				}
			}
			throw new ClassNotFoundException(name);
		}
	}

	public static byte[] decryptByPrivateKey(byte[] data,
			InputStream keyStoreInputStream) throws Exception {
		
		ByteArrayOutputStream rtn = null;	
		try {
			PrivateKey privateKey = getPrivateKey(keyStoreInputStream, alias,
					password);
			Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm(), "SunJCE");
			
			cipher.init(Cipher.DECRYPT_MODE, privateKey);
	
			rtn = new ByteArrayOutputStream();

			for (int i = 0; i < data.length; i += 128) {
				int len = data.length - i > 128 ? 128 : data.length - i;
				byte[] tmp = cipher.doFinal(data, i, len);
				rtn.write(tmp);
			}

			rtn.flush();
			return rtn.toByteArray();
		} catch (Exception e) {
			throw e;
		}finally {
			if(rtn != null)rtn.close();
		}

	}

	private static PrivateKey getPrivateKey(InputStream keyStoreInputStream,
			String alias, String password) throws Exception {
		PrivateKey key =null;
		try {
		
			KeyStore ks = getKeyStore(keyStoreInputStream, password);
			key = (PrivateKey) ks.getKey(alias, password.toCharArray());
		} catch (Exception e) {
			throw e;
		}
		return key;
	}

	private static KeyStore getKeyStore(InputStream is, String password)
			throws Exception {

		KeyStore ks = KeyStore.getInstance(KEY_STORE);
		ks.load(is, password.toCharArray());
		is.close();
		return ks;
	}

	private static FileInputStream loadLicenseFile()
			throws FileNotFoundException {
		String path = PropertyUtil.getPath()+"/license5.x.zip";

		log.info("Used License file at:" + path);
		FileInputStream fis = null;
		fis = new FileInputStream(path);
		return fis;
	}

	public static byte[] readZipEnry(String entryName) throws Exception {

		if (datas.get(entryName) != null) {
			return datas.get(entryName);
		} else {

			try {
				FileInputStream fis = loadLicenseFile();
				ZipInputStream zis = null;

				try {
					zis = new ZipInputStream(fis);
					ZipEntry zEntry = null;
					do {
						zEntry = zis.getNextEntry();
						if (zEntry != null) {
							ByteArrayOutputStream baos = new ByteArrayOutputStream();

							while (zis.available() > 0) {
								int b = zis.read();
								if (b >= 0)
									baos.write(b);
							}

							byte[] data = baos.toByteArray();

							zis.closeEntry();
							zis.read(data);
							datas.put(zEntry.getName(), data);
						}

					} while (zEntry != null);
				} finally {
					zis.close();
					fis.close();
				}
			} catch (Exception e) {
				throw new Exception("(" + e.getMessage() + ")");
			}
			return datas.get(entryName);
		}
	}
}