package com.teemlink.qm.questionnaire.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.answer.service.AnswerProcessBean;
import com.teemlink.qm.base.dao.BaseDAO;
import com.teemlink.qm.base.dao.DaoManager;
import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.User;
import com.teemlink.qm.base.model.ValueObject;
import com.teemlink.qm.base.model.WebUser;
import com.teemlink.qm.base.service.AbstractBaseProcessBean;
import com.teemlink.qm.config.UserAPI;
import com.teemlink.qm.notification.QuestionnaireNotificationService;
import com.teemlink.qm.notification.QuestionnaireNotificationServiceImpl;
import com.teemlink.qm.questionnaire.dao.AbstractQuestionnaireDAO;
import com.teemlink.qm.questionnaire.dao.QuestionnaireDAO;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import com.teemlink.qm.util.CensusUtil;
import com.teemlink.qm.util.Sequence;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.*;

public class QuestionnaireProcessBean extends
		AbstractBaseProcessBean<QuestionnaireVO> implements
		QuestionnaireProcess {

	public ValueObject doUpdate(ValueObject vo) throws Exception {
		return ((QuestionnaireDAO) getDAO()).update(vo);
	}

	public void doRemove(String pk) throws Exception {
		AnswerProcessBean answerProcessBean = new AnswerProcessBean();
		DataPackage<AnswerVO> datas = answerProcessBean
				.doViewForQuestionnaire(pk);
		if (datas != null) {
			for (Iterator<AnswerVO> iter = datas.datas.iterator(); iter
					.hasNext();) {
				AnswerVO answer = iter.next();
				answerProcessBean.doRemove(answer.getId());
			}
		}

		((QuestionnaireDAO) getDAO()).delete(pk);
	}

	@Override
	public void doRemove(String[] pks) throws Exception {
		super.doRemove(pks);
	}

	@Override
	public Collection<QuestionnaireVO> doSimpleQuery(ParamsTable params,
			WebUser user) throws Exception {
		return null;
	}

    public ValueObject doSave(ValueObject vo) throws Exception {
	try {
	    QuestionnaireVO questionnaireVO = (QuestionnaireVO) vo;
	    int score = CensusUtil.totalScore((QuestionnaireVO) vo);
	    questionnaireVO.setScore(score);

//	    UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
		UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);

		String scope = questionnaireVO.getScope();
	    Set<String> idBuffer = new HashSet<String>();
	    Set<String> nameBuffer = new HashSet<String>();
	    if (QuestionnaireVO.SCOPE_USER.equalsIgnoreCase(scope)) {
		
		//添加相应角色的用户信息
		idBuffer.add(questionnaireVO.getOwnerIds());
		nameBuffer.add(questionnaireVO.getOwnerNames());
		
	    } else if (QuestionnaireVO.SCOPE_ROLE.equalsIgnoreCase(scope)) {
		String roleId = questionnaireVO.getOwnerIds();


		//添加相应角色的用户信息
		for (String role : roleId.split(";")) {
			if (StringUtil.isBlank(role))
			continue;
			Map<String,String>  content = new HashMap<>();
			content.put("roleid",roleId);
			ResultWarp<DataPackage<User>> dataPackageResultWarp = userAPI.queryUsers(questionnaireVO.getDomainid(), content);
			Collection<User> users = dataPackageResultWarp.getData().datas;
		    for (User user : users) {
			idBuffer.add(user.getId());
			nameBuffer.add(user.getName());
		    }
		}

	    } else if (QuestionnaireVO.SCOPE_DEPT.equalsIgnoreCase(scope)) {
		String deptId = questionnaireVO.getOwnerIds();
		
		//添加相应部门的用户信息
		for (String dept : deptId.split(";")) {
		    if (StringUtil.isBlank(dept))
			continue;
			ResultWarp<DataPackage<User>> departmentUsers = userAPI.getDepartmentUsers(deptId, String.valueOf(1), String.valueOf(9999));
			Collection<User> users = departmentUsers.getData().datas;
		    for (User user : users) {
			idBuffer.add(user.getId());
			nameBuffer.add(user.getName());
		    }
		}

	    } else if (QuestionnaireVO.SCOPE_DEPTANDROLE.equalsIgnoreCase(scope)) {
		String roleIdAnddeptId = questionnaireVO.getOwnerIds();

		//添加相应部门的用户信息
		String deptId = roleIdAnddeptId.split(";;")[0];
		for (String dept : deptId.split(";")) {
		    if (StringUtil.isBlank(dept))
			continue;
//			Map<String,String>  content = new HashMap<>();
			ResultWarp<DataPackage<User>> departmentUsers = userAPI.getDepartmentUsers(deptId, String.valueOf(1), String.valueOf(9999));
			Collection<User> users = departmentUsers.getData().datas;
		    for (User user : users) {
			idBuffer.add(user.getId());
			nameBuffer.add(user.getName());
		    }
		}
		
		//添加相应角色的用户信息
		String roleId = roleIdAnddeptId.split(";;")[1];
		for (String role : roleId.split(";")) {
		    if (StringUtil.isBlank(role))
			continue;
			Map<String,String>  content = new HashMap<>();
			content.put("roleid",roleId);
			ResultWarp<DataPackage<User>> dataPackageResultWarp = userAPI.queryUsers(questionnaireVO.getDomainid(), content);
			Collection<User> users = dataPackageResultWarp.getData().datas;
		    for (User user : users) {
			idBuffer.add(user.getId());
			nameBuffer.add(user.getName());
		    }
		}

	    }

	    StringBuffer id = new StringBuffer();
	    StringBuffer name = new StringBuffer();
	    for(String idStr:idBuffer){
		id.append(idStr).append(";");
	    }
	    for(String nameStr:nameBuffer){
		name.append(nameStr).append(";");
	    }
	    questionnaireVO.setActorIds(id.toString().substring(0,id.toString().length() - 1));
	    questionnaireVO.setActorNames(name.toString().substring(0,name.toString().length() - 1));

	    if(QuestionnaireVO.STATUS_PUBLISH == questionnaireVO.getStatus())
	    	questionnaireVO.setPublishDate(new Date());
	    
	    if (StringUtil.isBlank(questionnaireVO.getId())) {
		questionnaireVO.setId(Sequence.getSequence());
		questionnaireVO = (QuestionnaireVO) doCreate(questionnaireVO);
	    } else {
		questionnaireVO = (QuestionnaireVO) doUpdate(questionnaireVO);
	    }
    	QuestionnaireNotificationService questionnaireNotificationService = new QuestionnaireNotificationServiceImpl();
	    if(QuestionnaireVO.STATUS_PUBLISH == questionnaireVO.getStatus()){
			//发送消息
			questionnaireNotificationService.publish(questionnaireVO);
	    }else if(QuestionnaireVO.STATUS_RECOVER == questionnaireVO.getStatus()){
			questionnaireNotificationService.completeQuestionnaire(questionnaireVO);
	    }

	} catch (Exception e) {
	    e.printStackTrace();
	}
	return vo;
    }

	@Override
	public ValueObject doCreate(ValueObject vo) throws Exception {
		((QuestionnaireVO) vo).setCreateDate(new Date());
		return super.doCreate(vo);
	}

	@Override
	public BaseDAO getDAO() throws Exception {
		return DaoManager.getQuestionnaireDAO(getConnection());
	}

	@Override
	public DataPackage<QuestionnaireVO> doQuery(ParamsTable params, WebUser user)
			throws Exception {
		DataPackage<QuestionnaireVO> datas = ((QuestionnaireDAO) getDAO())
				.query(user);
		return datas;
	}

	public DataPackage<QuestionnaireVO> doQuery(WebUser user) throws Exception {
		DataPackage<QuestionnaireVO> datas = ((QuestionnaireDAO) getDAO())
				.query(user);
		return datas;
	}

	public QuestionnaireVO doShowResult(String pk, WebUser user)
			throws Exception {
		QuestionnaireVO vo = (QuestionnaireVO) doView(pk);
		if (vo != null) {
			AnswerProcessBean answerBean = new AnswerProcessBean();
			DataPackage<AnswerVO> datas = answerBean.doViewForQuestionnaire(pk);
			if (datas != null) {
				String json = CensusUtil.createCensus(datas.datas);
				vo.setChartJson(json);
			}
		}
		return vo;
	}
	
	public QuestionnaireVO showReportForm(String pk)
			throws Exception {
		QuestionnaireVO vo = (QuestionnaireVO) doView(pk);
		if (vo != null) {
			AnswerProcessBean answerBean = new AnswerProcessBean();
			DataPackage<AnswerVO> datas = answerBean.doViewForQuestionnaire(pk);
			if (datas != null) {
				String json = CensusUtil.reportForm(datas.datas,vo.getContent());
				vo.setChartJson(json);
			}
		}
		return vo;
	}

	public String doShowVoteNumber(String pk, String holder_id, WebUser user)
			throws Exception {
		QuestionnaireVO vo = (QuestionnaireVO) doView(pk);
		String json = "";
		if (vo != null) {
			AnswerProcessBean answerBean = new AnswerProcessBean();
			DataPackage<AnswerVO> datas = answerBean.doViewForQuestionnaire(pk);
			if (datas != null) {
				json = CensusUtil.voteNumber(datas.datas, holder_id);
			}
		}
		return json;
	}

	/**
	 * 查询当前用户需要填写的问卷
	 */
	public DataPackage<QuestionnaireVO> doQueryByPublish(WebUser user)
			throws Exception {
		return ((QuestionnaireDAO) getDAO())
				.queryByPublish(user);
	}

	/**
	 * 新建问卷
	 */
	public QuestionnaireVO doNew() throws Exception {
		QuestionnaireVO vo = new QuestionnaireVO();
		vo.setTitle("我的问卷");

		JSONArray holders = new JSONArray();
		for (int i = 0; i < 2; i++) {
			JSONObject holder = new JSONObject();
			holder.put("id", UUID.randomUUID().toString());
			holder.put("topic", "请输入题目");
			holder.put("type", "radio");
			JSONArray options = new JSONArray();
			for (int j = 0; j < 2; j++) {
				JSONObject option = new JSONObject();
				option.put("name", "选项");
				options.put(option);
			}
			holder.put("options", options);
			holders.put(holder);
		}

		vo.setContent(holders.toString());
		vo.setScope(QuestionnaireVO.SCOPE_USER);
		return vo;
	}

	/**
	 * 查询根据条件查找实例集合
	 * 
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("deprecation")
	public DataPackage<QuestionnaireVO> doQueryByFilter(String s_title,
			int page, int lines, WebUser user) throws Exception {
		return ((QuestionnaireDAO) getDAO()).queryByFilter(s_title, page,
				lines, user);
	}

	public ValueObject doReBuild(ValueObject vo) throws Exception {
		AnswerProcessBean answerProcessBean = new AnswerProcessBean();
		DataPackage<AnswerVO> datas = answerProcessBean
				.doViewForQuestionnaire(vo.getId());
		if (datas != null) {
			for (Iterator<AnswerVO> iter = datas.datas.iterator(); iter
					.hasNext();) {
				AnswerVO answer = iter.next();
				answerProcessBean.doRemove(answer.getId());
			}
		}
		return vo;
	}

	@SuppressWarnings("deprecation")
	public DataPackage<QuestionnaireVO> doQueryByPublishDone(WebUser user)
			throws Exception {
		DataPackage<QuestionnaireVO> datas = ((QuestionnaireDAO) getDAO())
				.queryByPublishDone(user);
		Collection<QuestionnaireVO> newData = new ArrayList<QuestionnaireVO>();
		if (datas.datas != null) {
			for (Iterator<QuestionnaireVO> iter = datas.datas.iterator(); iter
					.hasNext();) {
				QuestionnaireVO questionnaire = iter.next();
				// 判断用户是否需要填写该问卷
				boolean flag = questionnaire.validatePublish(user);
				if (flag) {
					newData.add(questionnaire);
				}

			}
		}
		datas.setDatas(newData);
		return datas;
	}

	@Override
	public DataPackage<QuestionnaireVO> doQueryMyPublish(String title,
			int status, int page, int lines, WebUser user) throws Exception {
		return ((AbstractQuestionnaireDAO) getDAO()).doQueryMyPublish(title, status, page,
				lines, user);
	}

	@Override
	public DataPackage<QuestionnaireVO> doQueryMyPartake(String title,
			int status, int page, int lines, WebUser user) throws Exception {
		DataPackage<QuestionnaireVO> dataPackage = new DataPackage<QuestionnaireVO>();
		if(AnswerVO.STATUS_ALL==status){
			dataPackage = ((AbstractQuestionnaireDAO) getDAO())
					.doQueryMyPartakeAll(title, status, page, lines, user);
		}else if(AnswerVO.STATUS_FILLING==status){
			dataPackage = ((AbstractQuestionnaireDAO) getDAO()).doQueryMyPartake(title, status, page,
					lines, user);
			
		}else if(AnswerVO.STATUS_FILLED==status){
			dataPackage = ((AbstractQuestionnaireDAO) getDAO()).doQueryMyPartake(title, status, page,
					lines, user);
			
		} else{
			throw new Exception("请输入正确的status参数");
		}
		
		return dataPackage;
	}

	@Override
	public boolean addPaticipate(String id) throws Exception {
		return ((QuestionnaireDAO) getDAO()).addPaticipate(id);
	}
	
}
