package com.teemlink.qm.questionnaire.dao;

import java.sql.Connection;
import java.sql.SQLException;

import com.teemlink.qm.util.DbTypeUtil;

public class DmSQLQuestionnaireDAO extends AbstractQuestionnaireDAO implements QuestionnaireDAO {

	public DmSQLQuestionnaireDAO(Connection conn) {
		super(conn);
		dbTag = "DM: ";
		if (conn != null) {
			this.schema = DbTypeUtil.getSchema(conn, DbTypeUtil.DBTYPE_DM);
		}
	}
	
	/**
	 * 生成限制条件sql.
	 * 
	 * @param sql
	 *            sql语句
	 * @param page
	 *            当前页码
	 * @param lines
	 *            每页显示行数
	 * @return 生成限制条件sql语句字符串
	 * @throws SQLException
	 */
	public String buildLimitString(String sql, int page, int lines, String orderbyField, String orderbyMode)
			throws SQLException {
		if (lines == Integer.MAX_VALUE) {
			return sql;
		}

		int to = (page - 1) * lines;
		StringBuffer pagingSelect = new StringBuffer(100);
		
		pagingSelect.append("SELECT * FROM (");
		pagingSelect.append(sql);
		pagingSelect.append(" ) AS TB"+" LIMIT " + lines + " OFFSET " + to);

		return pagingSelect.toString();
	}

}
