package com.teemlink.qm.questionnaire.controller;


import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teemlink.qm.base.controller.BaseController;
import com.teemlink.qm.base.model.*;
import com.teemlink.qm.config.*;
import com.teemlink.qm.questionnaire.model.Node;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.net.URLDecoder;
import java.util.*;

@Controller(value = "UserRoleDepartmentController")
@RequestMapping(value = "/qm")
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include = JsonSerialize.Inclusion.NON_NULL)
public class UserRoleDepartmentController extends BaseController<QuestionnaireVO> {

    @MapInModel
    protected Collection<Node> childNodes = new ArrayList<Node>();

    @RequestMapping(value = "/getRolesList.action")
    public ModelAndView doRolesList() {
        StringBuffer html = new StringBuffer();
        ModelAndView modelAndView = new ModelAndView();
        try {
//            RoleDesignTimeService roleService = (RoleDesignTimeService) DesignTimeServiceFactory.resolve(RoleDesignTimeService.class);
            RoleAPI roleAPI = SpringApplicationContextUtil.getBean(RoleAPI.class);
            ParamsTable params = this.getParams();
            params.setParameter("_pagelines", 10);
            params.setParameter("_orderby", "name");

            String applicationId = params.getParameterAsString("application");
            String domainId = params.getParameterAsString("domainid");

            html.append("<div>");
            //根据 applicationId 对软件用户进行筛选，若applicationId为空，则显示所有用户（兼容旧数据）
            if("null".equalsIgnoreCase(applicationId) || StringUtil.isBlank(applicationId)){
//                ApplicationDesignTimeService appService = (ApplicationDesignTimeService) DesignTimeServiceFactory.resolve(ApplicationDesignTimeService.class);
                ApplicationAPI  applicationAPI = SpringApplicationContextUtil.getBean(ApplicationAPI.class);
                Collection<Application> appList = null;
                if("null".equalsIgnoreCase(domainId) || StringUtil.isBlank(domainId)){
//                    appList = appService.list(null,null);
                    ResultWarp<List<Application>> listResultWarp = applicationAPI.queryAll();
                    appList = listResultWarp.getData();
                } else {
//                    DomainProcess dp = (DomainProcess) ProcessFactory.createProcess(DomainProcess.class);
//                    DomainVO d = (DomainVO) dp.doView(domainId);
                    Map<String,String> map = new HashMap();
                    map.put("name","");
                    ResultWarp<DataPackage<Application>> dataPackageResultWarp = applicationAPI.queryAppByDomainid(domainId, map);
                    appList = dataPackageResultWarp.getData().datas;
                }
                for(Application applicationVO : appList) {
                    if (!applicationVO.isActivated()) {
                        continue;
                    }
                    params.setParameter("application", applicationVO.getId());
                    params.setParameter("t_status", Role.STATUS_VALID);

//                    Collection<Role> datas = roleService.getRolesByApplication(applicationVO.getApplicationid());
                    ResultWarp<List<Role>> listResultWarp = roleAPI.queryByAppid(applicationId);
                    Collection<Role> datas= listResultWarp.getData();
                    //将角色状态失效的去除
                    Iterator<Role> roleIterator = datas.iterator();
                    while(roleIterator.hasNext()){
                        Role roleTemp = roleIterator.next();
                        if(roleTemp.getStatus() == Role.STATUS_INVALID)
                            roleIterator.remove();
                    }
                    html.append("<font style='font-weight:bold;'>" + applicationVO.getName() + "</font>");
                    for (Iterator<Role> iter = datas.iterator(); iter.hasNext();) {
                        Role tempRole = (Role) iter.next();
                        html.append("<div id='" + tempRole.getId() + "' class='list_div' title='" + tempRole.getName()
                                + "' onclick='getUserListByRole(jQuery(this))'>");
                        html.append("<img id='img_" + tempRole.getId() + "' class='selectImg_right' src='"
                                + "/qms" + "/uploads/resource/images/right_2.gif'/>");
                        html.append(tempRole.getName());
                        html.append("</div>");
                    }

                }
            }else{
//                ApplicationDesignTimeService appService = (ApplicationDesignTimeService) DesignTimeServiceFactory.resolve(ApplicationDesignTimeService.class);
//                Application applicationVO = (Application)appService.findById(applicationId);
                params.setParameter("application", applicationId);
                params.setParameter("t_status", Role.STATUS_VALID);
//                Collection<Role> datas = roleService.getRolesByApplication(applicationId);
                //将角色状态失效的去除
                ResultWarp<List<Role>> listResultWarp = roleAPI.queryByAppid(applicationId);
                Collection<Role> datas = listResultWarp.getData();
                Iterator<Role> roleIterator = datas.iterator();
                while(roleIterator.hasNext()){
                    Role roleTemp = roleIterator.next();
                    if(roleTemp.getStatus() == Role.STATUS_INVALID)
                        roleIterator.remove();
                }
                //applicationVO.getName()
                html.append("<font style='font-weight:bold;'>" + "" + "</font>");
                for (Iterator<Role> iter = datas.iterator(); iter.hasNext();) {
                    Role tempRole = (Role) iter.next();
                    html.append("<div id='" + tempRole.getId() + "' class='list_div' title='" + tempRole.getName()
                            + "' onclick='getUserListByRole(jQuery(this))'>");
                    html.append("<img id='img_" + tempRole.getId() + "' class='selectImg_right' src='"
                            + "/qms" + "/uploads/resource/images/right_2.gif'/>");
                    html.append(tempRole.getName());
                    html.append("</div>");
                }
            }

            html.append("</div>");
//			modelAndView.addObject("HTML",html.toString());
            request.setAttribute("HTML",html.toString());
        }  catch (OBPMValidateException e) {
            modelAndView.addObject("ERROR_MESSAGE",e.getValidateMessage());
        }catch (Exception e) {
            modelAndView.addObject("runtimeException",e.getMessage());
            e.printStackTrace();
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
//			INPUT.setNamespace("/portal/share/user").setInputJsp("htmlData");
//			SUCCESS.setNamespace("/portal/share/user").setSuccessJsp("htmlData");
        }
        return modelAndView;
    }


    /**
     * 根据角色查找用户列表
     *
     * @return
     */
    // @SuppressWarnings("unchecked")
    @RequestMapping(value = "/getUserListByRole.action")
    @ResponseBody
    public ModelAndView doUserListByRole() {
        StringBuffer html=new StringBuffer();
        ModelAndView modelAndView = new ModelAndView();
        String htmlTemp="";
        try {
//            UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
            ParamsTable params = getParams();
            String applicationid = params.getParameterAsString("applicationid");
            String roleId=params.getParameterAsString("rolesid");
            String selectMode = params.getParameterAsString("selectMode");

            int total = 0;
            Long lines = this.getParams().getParameterAsLong("_pagelines");
            int pagelines = lines != null ? lines.intValue() : 10;
            params.setParameter("_pagelines", String.valueOf(pagelines));
            Long page = params.getParameterAsLong("_currpage");
            int currentPage = page != null ? page.intValue() : 1;
            if (applicationid != null && applicationid.trim().length() > 0) {
                if (roleId != null && !"".equals(roleId)) {
//                    UserVO userVO = (UserVO)userProcess.doView(getUser().getId());
                    User userVO = userAPI.getUserById(getUser().getId()).getData();
                    Map<String,String> content = new HashMap<>();
                    content.put("roleid",roleId);
                    ResultWarp<DataPackage<User>> dataPackageResultWarp = userAPI.queryUsers(userVO.getDomainid(), content);
                    //DataPackage<UserVO> users = userProcess.queryByRoleForUserDialog(roleId, this.getUser(),null,currentPage,pagelines);
                    DataPackage<User> users = dataPackageResultWarp.getData();
                    total = users.rowCount;
                    for (Iterator<User> iter = users.datas.iterator(); iter
                            .hasNext();) {
                        User tempUser = iter.next();
                        String avatar = "";
//                        if(!StringUtil.isBlank(tempUser.getAvatar())){
//                            avatar = tempUser.getAvatarUri();
//                        }
//                        String email = this.getUserEmail(tempUser);
                        String email = tempUser.getEmail();
                        html.append("<div class='list_div' title='"
                                + tempUser.getName() + "'>");
                        if("selectOne".equals(selectMode)){
                            html
                                    .append("<input class='list_div_click' type='radio' name='"
                                            + tempUser.getName()
                                            + "' id='"
                                            + tempUser.getId()
                                            + "' email='"
                                            + email
                                            + "' avatar='"
                                            + avatar
                                            + "' emailAccount='"
                                            + getUserEmailAccount(email)
                                            + "' telephone='"
                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
                            html.append("<span onclick='" +
                                    "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>"+tempUser.getName()+"</span>");
                            html.append("</div>");
                        }else{
                            html
                                    .append("<input class='list_div_click' type='checkbox' name='"
                                            + tempUser.getName()
                                            + "' id='"
                                            + tempUser.getId()
                                            + "' email='"
                                            + email
                                            + "' avatar='"
                                            + avatar
                                            + "' emailAccount='"
                                            + getUserEmailAccount(email)
                                            + "' telephone='"
                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
                            html.append("<span onclick='" +
                                    "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>"+tempUser.getName()+"</span>");
                            html.append("</div>");
                        }
                    }
                    String url = "/qm/getUserListByRole.action?applicationid="
                            + applicationid;
                    url += "&rolesid=" + roleId + "&selectMode=" + selectMode;
                    getPageDiv(html, currentPage, total, url);
                }
            }

            request.setAttribute("HTML", html.toString());

        }catch (OBPMValidateException e) {
            modelAndView.addObject("ERROR_MESSAGE",e.getValidateMessage());
//			INPUT.addFieldError(e.getValidateMessage());
        }catch (Exception e) {
            modelAndView.addObject("runtimeException",e.getMessage());
//			INPUT.setRuntimeException(new OBPMRuntimeException("{*[OBPMRuntimeException]*}",e));
            e.printStackTrace();
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
//			SUCCESS.setNamespace("/portal/share/user").setSuccessJsp("htmlData");
        }
        return modelAndView;
    }

//    /**
//     * 获取用户Email
//     * @param tempUser
//     * @return
//     * @throws Exception
//     */
//    private String getUserEmail(BaseUser tempUser) throws Exception{
//        String email = "" ;
//        String domainId = tempUser.getDomainid();
//        DomainProcess domainProcess = (DomainProcess) ProcessFactory.createProcess(DomainProcess.class);
//        DomainVO domain = (DomainVO) domainProcess.doView(domainId);
//        if("true".equals(domain.getIsUseClient())){
//            EmailUserProcess euserpro = (EmailUserProcess) ProcessFactory
//                    .createProcess(EmailUserProcess.class);
//            EmailUser emailUser =  euserpro.getEmailUserByOwner(tempUser.getId(), tempUser.getDomainid());
//            email = new EmailHelper().showAccount(emailUser);
//        }
//        if(StringUtil.isBlank(email)){
//            if(!StringUtil.isBlank(tempUser.getEmail())){
//                email = tempUser.getName() + "<"+ tempUser.getEmail() +">";
//            }
//        }
//        return email == null ? "" : email;
//    }

    private String getUserEmailAccount(String email){
        if(!StringUtil.isBlank(email)&& email.indexOf("@") > 0){
            String ea=email.substring(email.indexOf("<")+1, email.indexOf("@"));
            return ea;
        }
        return "";
    }

    public void getPageDiv(StringBuffer html, int currentPage, int total,
                           String url) {
        Long lines = this.getParams().getParameterAsLong("_pagelines");
        long pagelines = lines != null ? lines : 10;

        int pageCount = (int) Math.ceil((double) total / pagelines);

        html.append("<div class='user_run_page' style='padding:5px;border-bottom:1px solid gray;'>");

        if (currentPage > 1) {
            html
                    .append("<a style='cursor: pointer;' onclick='doPageNav(\""
                            + url
                            + "&_currpage=1\")'>首页</a>&nbsp;");
            html
                    .append("<a style='cursor: pointer;' onclick='doPageNav(\""
                            + url
                            + "&_currpage="
                            + (currentPage - 1)
                            + "\")'>上一页</a>&nbsp;");
        }

        if (currentPage < pageCount) {
            html
                    .append("<a style='cursor: pointer;' onclick='doPageNav(\""
                            + url
                            + "&_currpage="
                            + (currentPage + 1)
                            + "\")'>下一页</a>&nbsp;");
            html
                    .append("<a style='cursor: pointer;' onclick='doPageNav(\""
                            + url
                            + "&_currpage="
                            + pageCount
                            + "\")'>末页</a>&nbsp;");
        }

        if (pageCount > 1) {
            html.append("<a style='cursor: pointer;' onclick='doPageNav(\""
                    + url
                    + "&_currpage=1"
                    + "&_pagelines=" + String.valueOf(Integer.MAX_VALUE)
                    + "&_returnPage="
                    + currentPage
                    + "\")'>所有</a>&nbsp;");
        }

        if (pageCount <= 1 && pagelines > 10) {
            Long rtnPage = this.getParams().getParameterAsLong("_returnPage");
            long returnPage = rtnPage != null ? rtnPage : currentPage;
            html.append("<a style='cursor: pointer;' onclick='doPageNav(\""
                    + url
                    + "&_currpage="
                    + returnPage
                    + "\")'>分页</a>&nbsp;");
        }

        html.append("<a>第").append(currentPage).append(
                "页/总计").append(pageCount).append(
                "页</a>&nbsp;");

        html.append("</div>");
    }

    /**
     * 显示部门树
     *
     * @throws Exception
     */
    @RequestMapping(value = "/departTree.action")
    @ResponseBody
    public Collection<Node> departTree() {

        ParamsTable params = getParams();
        String parentid = params.getParameterAsString("parentid");
        String domain = params.getParameterAsString("domain");

        try {
//            DepartmentProcess dp = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
            DepartmentAPI departmentAPI = SpringApplicationContextUtil.getBean(DepartmentAPI.class);
            if (parentid == null || "".equals(parentid)) {
//                Collection<DepartmentVO> depts = dp.getDepartmentByLevel(0,domain);
                ResultWarp<Department> resultWarpDepartment = departmentAPI.getRootDepartments(domain);
                Department root = resultWarpDepartment.getData();
//                for (Iterator<DepartmentVO> ite = depts.iterator(); ite.hasNext();) {
//                    DepartmentVO dept = ite.next();
//                    if(dept.getValid() == 1 && (dept.getSuperior() == null || (dept.getSuperior() != null && dept.getSuperior().getValid() == 1))){
//                        Node node = new Node();
//                        node.setId(dept.getId());
//                        node.setData(dept.getName());
//                        node.addAttr("name", dept.getName());
//                        if ((dp.getChildrenCount(dept.getId())) > 0) {
//                            node.setState(Node.STATE_CLOSED);
//                        }
//                        childNodes.add(node);
//                    }
//                }
                Node node = new Node();
                node.setId(root.getId());
                node.setData(root.getName());
                node.addAttr("name", root.getName());
                node.setState(Node.STATE_CLOSED);
                childNodes.add(node);
                return childNodes;
            } else {
                //Collection<DepartmentVO> depts = dp.getDatasByParent(parentid);
                Department parent = departmentAPI.getDepartmentById(parentid).getData();
                if(parent!=null&&parent.getValid()==1){
                    List<Department> subDepartments = departmentAPI.getSubDepartments(domain, parentid).getData();
                    for (Iterator<Department> ite = subDepartments.iterator(); ite.hasNext();) {
                        Department dept = ite.next();
                        if(dept.getValid() == 1){
                            Node node = new Node();
                            node.setId(dept.getId());
                            node.setData(dept.getName());
                            node.addAttr("name", dept.getName());
                            if (dept.isLeaf()) {
                                node.setState(Node.STATE_CLOSED);
                            }
                            childNodes.add(node);
                        }
                    }
                }


                return childNodes;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return childNodes;
    }

    /**
     * 根据部门获取用户列表
     *
     * @return
     */
    @RequestMapping(value = "/getUserListByDept.action")
    @ResponseBody
    public ModelAndView doUserListByDept() {
        StringBuffer html=new StringBuffer();
        ModelAndView modelAndView = new ModelAndView();
        String htmlTemp ="";
        try {
//            UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            ParamsTable params = getParams();
            String departid = params.getParameterAsString("departid");
            String domain = params.getParameterAsString("domain");
            String selectMode = params.getParameterAsString("selectMode");

            Long lines = this.getParams().getParameterAsLong("_pagelines");
            int pagelines = lines != null ? lines.intValue() : 10;
            params.setParameter("_pagelines", String.valueOf(pagelines));

            Long page = this.getParams().getParameterAsLong("_currpage");
            int currentPage = page != null ? page.intValue() : 1;

            int total = 0;
            if (domain != null && domain.trim().length() > 0) {
                if (departid != null && !"".equals(departid)) {
//                    DataPackage<UserVO> users = userProcess.queryByDeptForUserDialog(departid, domain, null, this.getUser(), null, currentPage, pagelines);
                    UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
//                    Map<String,String> content = new HashMap<>();
                    DataPackage<User> users = userAPI.getDepartmentUsers(departid,String.valueOf(currentPage),String.valueOf(pagelines)).getData();
                    total = users.rowCount;

                    for (Iterator<User> iter = users.datas.iterator(); iter.hasNext(); ) {
                        User tempUser = iter.next();
                        String email = tempUser.getEmail();
                        String avatar = "";
//                        if (!cn.myapps.util.StringUtil.isBlank(tempUser.getAvatar())) {
//                            avatar = tempUser.getAvatarUri();
//                        }
                        html.append("<div class='list_div' title='"
                                + tempUser.getName() + "'>");
                        if ("selectOne".equals(selectMode)) {
                            html
                                    .append("<input class='list_div_click' type='radio' name='"
                                            + tempUser.getName()
                                            + "' id='"
                                            + tempUser.getId()
                                            + "' email='"
                                            + email
                                            + "' avatar='"
                                            + avatar
                                            + "' emailAccount='"
                                            + getUserEmailAccount(email)
                                            + "' telephone='"
                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
                            html.append("<span onclick='" +
                                    "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>" + tempUser.getName() + "</span>");
                            html.append("</div>");
                        } else {
                            html
                                    .append("<input class='list_div_click' type='checkbox' name='"
                                            + tempUser.getName()
                                            + "' id='"
                                            + tempUser.getId()
                                            + "' email='"
                                            + email
                                            + "' avatar='"
                                            + avatar
                                            + "' emailAccount='"
                                            + getUserEmailAccount(email)
                                            + "' telephone='"
                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
                            html.append("<span onclick='" +
                                    "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>" + tempUser.getName() + "</span>");
                            html.append("</div>");
                        }
                    }

                    if (total > 0) {
                        String url = "/qm/getUserListByDept.action?departid="
                                + departid;
                        url += "&domain=" + domain + "&selectMode=" + selectMode;
                        getPageDiv(html, currentPage, total, url);
                    }
                    if (total == 0) {
                        html.append("<div class='list_div'><span>"
                                + "找不到用户</span></div>");
                    }
                }
            }
            request.setAttribute("HTML",html.toString());
        }catch (OBPMValidateException e) {
            modelAndView.addObject("ERROR_MESSAGE",e.getValidateMessage());
//			INPUT.addFieldError(e.getValidateMessage());
        }catch (Exception e) {
            modelAndView.addObject("runtimeException",e.getMessage());
//			INPUT.setRuntimeException(new OBPMRuntimeException("{*[OBPMRuntimeException]*}",e));
            e.printStackTrace();
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
//			SUCCESS.setNamespace("/portal/share/user").setSuccessJsp("htmlData");
        }
        return modelAndView;
    }

    /**
     * 获取所有在线用户列表
     *
     */
    // @SuppressWarnings("unchecked")
    @RequestMapping(value = "/getOnLineUserList.action")
    @ResponseBody
    public ModelAndView doOnLineUserList() {
        StringBuffer html = new StringBuffer();
        ModelAndView modelAndView = new ModelAndView();
        try {
            Long page = this.getParams().getParameterAsLong("_currpage");
            int currentPage = page != null ? page.intValue() : 1;

            Long lines = this.getParams().getParameterAsLong("_pagelines");
            int pagelines = lines != null ? lines.intValue() : 10;

            this.getParams().setParameter("_pagelines", String.valueOf(pagelines));
            String domain = getParams().getParameterAsString("domain");

            String selectMode = getParams().getParameterAsString("selectMode");
            DataPackage<WebUser> datas =null;
            //DataPackage<WebUser> datas = OnlineUsers.doQueryByDomain(this.getParams(), domain);

//            String useridStr = biuldUserIdStr();
            int rowCount = datas.getRowCount();
            for (Iterator<WebUser> iter = datas.datas.iterator(); iter.hasNext();) {
                WebUser tempUser = (WebUser) iter.next();
//                if(!StringUtil.isBlank(useridStr) && useridStr.indexOf(tempUser.getId()) == -1){
//                    rowCount--;
//                    continue;
//                }
                String avatar = "";
//                if(!StringUtil.isBlank(tempUser.getAvatar())){
//                    avatar = tempUser.getAvatarUri();
//                }
//                String email = this.getUserEmail(tempUser);
//                html.append("<div class='list_div' title='" + tempUser.getName()+(tempUser.isLiaisonOfficer()?"-[{*[core.user.LiaisonOfficer]*}]":"") + "'>");
//                if("selectOne".equals(selectMode)){
//                    html.append("<input class='list_div_click' type='radio' name='" + tempUser.getName() + "' id='"
//                            + tempUser.getId()
//                            + "' email='"
//                            + email
//                            + "' avatar='"
//                            + avatar
//                            + "' emailAccount='"
//                            + getUserEmailAccount(email) + "' telephone='"
//                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                }else{
//                    html.append("<input class='list_div_click' type='checkbox' name='" + tempUser.getName() + "' id='"
//                            + tempUser.getId()
//                            + "' email='"
//                            + email
//                            + "' avatar='"
//                            + avatar
//                            + "' emailAccount='"
//                            + getUserEmailAccount(email)+ "' telephone='"
//                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                }
                html.append("<span onclick='" +
                        "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>"+tempUser.getName()+"</span>");
                html.append("</div>");
            }
            html.append("<input type='hidden' value='" + rowCount
                    + "' id='onLineUsersCount' name='onLineUsersCount'>");
            int pageCount = (int) Math.ceil((double) rowCount / (double) datas.linesPerPage);
            if (pageCount > 0) {
                String url = "/qm/getOnLineUserList.action?_pagelines="+this.getParams().getParameterAsString("_pagelines")+"&domain="+domain;
                getLeftPageDiv(html, currentPage, rowCount, url);
            }
            request.setAttribute("HTML", html.toString());

        } catch (Exception e) {
//            INPUT.setRuntimeException(new OBPMRuntimeException("{*[OBPMRuntimeException]*}",e));

            e.printStackTrace();
        }finally {
//            SUCCESS.setNamespace("/portal/share/user").setSuccessJsp("htmlData");
            modelAndView.setViewName("qm/questionnaire/htmlData");
        }
        return modelAndView;
    }


    @RequestMapping(value = "/getContancts.action")
    public ModelAndView doContancts(){
        ModelAndView modelAndView = new ModelAndView();
        StringBuffer html = new StringBuffer();
        try {
            WebUser user = this.getUser();
//            UserGroupProcess userGroupProcess = (UserGroupProcess) ProcessFactory.createProcess(UserGroupProcess.class);
//            DataPackage<UserGroupVO> userGroups = userGroupProcess.getUserGroupsByUser(user.getId());
//            html.append("<div id='all' class='list_div' title='全部联系人' onclick='getUserListByContancts(jQuery(this))'>");
//            html.append("<img id='img_" + "all" + "' class='selectImg_right' src='"
//                    + "/qms" + "/uploads/resource/images/right_2.gif'/>");
//            html.append("全部联系人");
//            html.append("</div>");
//            for (Iterator<UserGroupVO> iter = userGroups.datas.iterator(); iter.hasNext();) {
//                UserGroupVO tempUserGroup = (UserGroupVO) iter.next();
//                html.append("<div id='" + tempUserGroup.getId() + "' class='list_div' title='" + tempUserGroup.getName()
//                        + "' onclick='getUserListByContancts(jQuery(this))'>");
//                html.append("<img id='img_" + tempUserGroup.getId() + "' class='selectImg_right' src='"
//                        + "/qms" + "/uploads/resource/images/right_2.gif'/>");
//                html.append(tempUserGroup.getName());
//                html.append("</div>");
//            }

            request.setAttribute("HTML", html.toString());
        } catch (OBPMValidateException e) {
            e.printStackTrace();
        }catch (Exception e) {
            e.printStackTrace();
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
        }
        return modelAndView;
    }

    @RequestMapping(value = "/getUserListBycontancts.action")
    public ModelAndView doUserListBycontancts(){
        StringBuffer html = new StringBuffer();
        ModelAndView modelAndView = new ModelAndView();
        try {
            ParamsTable params = getParams();
            Long page = params.getParameterAsLong("_currpage");
            int currentPage = page != null ? page.intValue() : 1;

            Long lines = this.getParams().getParameterAsLong("_pagelines");
            int pagelines = lines != null ? lines.intValue() : 10;

            int total = 0;
            Map<String,Object> sqlParameterMap = new HashMap<String,Object>();
            params.setParameter("_pagelines", String.valueOf(pagelines));

            String selectMode = params.getParameterAsString("selectMode");
            String hql = "";
            String domainid = params.getParameterAsString("domainid");
            String contanctsid = params.getParameterAsString("contanctsid");
//            if (domainid != null && domainid.trim().length() > 0) {
//                if (contanctsid != null && !"".equals(contanctsid)) {
//                    UserProcess userPorcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//                    DataPackage<UserVO> datas = userPorcess.getUserListAsContactsTree(domainid, contanctsid, "", currentPage, pagelines);
//                    Collection<UserVO> users = (Collection<UserVO>) datas.getDatas();
//                    total = datas.rowCount;
//                    for (Iterator<UserVO> iter = users.iterator(); iter
//                            .hasNext(); ) {
//                        UserVO tempUser = iter.next();
//                        String avatar = "";
//                        if (!StringUtil.isBlank(tempUser.getAvatar())) {
//                            avatar = tempUser.getAvatarUri();
//                        }
//                        String email = this.getUserEmail(tempUser);
//                        html.append("<div class='list_div' title='"
//                                + tempUser.getName() + "'>");
//                        if ("selectOne".equals(selectMode)) {
//                            html
//                                    .append("<input class='list_div_click' type='radio' name='"
//                                            + tempUser.getName()
//                                            + "' id='"
//                                            + tempUser.getId()
//                                            + "' email='"
//                                            + email
//                                            + "' avatar='"
//                                            + avatar
//                                            + "' emailAccount='"
//                                            + getUserEmailAccount(email)
//                                            + "' telephone='"
//                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                            html.append(tempUser.getName());
//                            html.append("</div>");
//                        } else {
//                            html
//                                    .append("<input class='list_div_click' type='checkbox' name='"
//                                            + tempUser.getName()
//                                            + "' id='"
//                                            + tempUser.getId()
//                                            + "' email='"
//                                            + email
//                                            + "' avatar='"
//                                            + avatar
//                                            + "' emailAccount='"
//                                            + getUserEmailAccount(email)
//                                            + "' telephone='"
//                                            + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                            html.append(tempUser.getName());
//                            html.append("</div>");
//                        }
//                    }
//                    String url = "/qm/getUserListBycontancts.action?domainid="
//                            + domainid;
//                    url += "&contanctsid=" + contanctsid + "&selectMode=" + selectMode;
//                    getPageDiv(html, currentPage, total, url);
//                }
//            }
            request.setAttribute("HTML", html.toString());

        } catch (Exception e) {
            modelAndView.addObject("ERROR_MESSAGE",e.getMessage());
            //INPUT.addFieldError(e.getValidateMessage());
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
        }
        //return SUCCESS.setNamespace("/portal/share/user").setSuccessJsp("htmlData");
        return modelAndView;
    }

    /**
     * 根据企业域获取所有用户列表
     *
     * @return
     */
    @RequestMapping(value = "/getAllUser.action")
    @ResponseBody
    public ModelAndView doAllUser() throws Exception {
        ModelAndView modelAndView = new ModelAndView();
        StringBuffer html=new StringBuffer();
        String htmlTemp ="";
        try {
            ParamsTable params = getParams();
            String selectMode = params.getParameterAsString("selectMode");
            String sm_name = params.getParameterAsString("sm_name");
            sm_name = URLDecoder.decode(sm_name);
            String domain = params.getParameterAsString("domain");

            Long page = this.getParams().getParameterAsLong("_currpage");
            int currentPage = page != null ? page.intValue() : 1;

            Long lines = this.getParams().getParameterAsLong("_pagelines");
            int pagelines = lines != null ? lines.intValue() : 10;

            int total = 0;
            this.getParams().setParameter("_pagelines", String.valueOf(pagelines));

          //  UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);

//            if (domain != null && domain.trim().length() > 0) {
//                DataPackage<UserVO> users = userProcess.queryForUserDialog(domain,sm_name,this.getUser(),null,currentPage,pagelines);
//                total = users.rowCount;
//                for (Iterator<UserVO> iter = users.datas.iterator(); iter.hasNext();) {
//                    UserVO tempUser = (UserVO) iter.next();
//                    String email = this.getUserEmail(tempUser);
//                    String avatar = "";
//                    if(!StringUtil.isBlank(tempUser.getAvatar())){
//                        avatar = tempUser.getAvatarUri();
//                    }
//                    html.append("<div class='list_div' title='"
//                            + tempUser.getName() + "'>");
//                    if("selectOne".equals(selectMode)){
//                        html
//                                .append("<input class='list_div_click' type='radio' name='"
//                                        + tempUser.getName()
//                                        + "' id='"
//                                        + tempUser.getId()
//                                        + "' avatar='"
//                                        + avatar
//                                        + "' email='"
//                                        + email
//                                        + "' emailAccount='"
//                                        + getUserEmailAccount(email)
//                                        + "' telephone='"
//                                        + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                        html.append("<span onclick='" +
//                                "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>"+tempUser.getName()+"</span>");
//                        html.append("</div>");
//                    }else {
//                        html
//                                .append("<input class='list_div_click' type='checkbox' name='"
//                                        + tempUser.getName()
//                                        + "' id='"
//                                        + tempUser.getId()
//                                        + "' avatar='"
//                                        + avatar
//                                        + "' email='"
//                                        + email
//                                        + "' emailAccount='"
//                                        + getUserEmailAccount(email)
//                                        + "' telephone='"
//                                        + tempUser.getTelephone() + "' onclick='selectUser(jQuery(this),true)'>");
//                        html.append("<span onclick='" +
//                                "jQuery(this).prev().click();selectUser(jQuery(this).prev(),true);'>"+tempUser.getName()+"</span>");
//                        html.append("</div>");
//                    }
//                }
//            }
            if (total > 0) {
                String url = "/qm/getAllUser.action?domain=" + domain
                        + "&sm_name=" + sm_name + "&selectMode=" + selectMode;
                getPageDiv(html, currentPage, total, url);
            }
            if (total == 0) {
                html.append("<div class='list_div'><span>找不到用户</span></div>");
            }
            request.setAttribute("HTML", html.toString());

        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            modelAndView.setViewName("qm/questionnaire/htmlData");
        }
        return modelAndView;
    }

    public void getLeftPageDiv(StringBuffer html, int currentPage, int total, String url) {
        int pageCount = (int) Math.ceil((double) total / 10.0);

        html.append("<div style='padding:5px;border-bottom:1px solid gray;'>");
        if (currentPage > 1) {
            html.append("<a style='cursor: pointer;color:#316AC5;' onclick='doLeftPageNav(\"" + url
                    + "&_currpage=1\")'>首页</a>&nbsp;");
            html.append("<a style='cursor: pointer;color:#316AC5;' onclick='doLeftPageNav(\"" + url + "&_currpage="
                    + (currentPage - 1) + "\")'>上一页</a>&nbsp;");
        }

        if (currentPage < pageCount) {
            html.append("<a style='cursor: pointer;color:#316AC5;' onclick='doLeftPageNav(\"" + url + "&_currpage="
                    + (currentPage + 1) + "\")'>下一页</a>&nbsp;");
            html.append("<a style='cursor: pointer;color:#316AC5;' onclick='doLeftPageNav(\"" + url + "&_currpage="
                    + pageCount + "\")'>末页</a>&nbsp;");
        }

        html.append("第").append(currentPage).append("页/总计").append(pageCount).append(
                "页&nbsp;");
        html.append("</div>");
    }

    /*public String biuldUserIdStr() throws Exception {
        StringBuffer w = new StringBuffer();
        ParamsTable params = getParams();
        String getToPerson = params.getParameterAsString("_isGetToPerson");//指定审批人
        String getApprover2SubFlow = params.getParameterAsString("_isGetApprover2SubFlow");//子流程节点选择审批人
        String getCirculator = params.getParameterAsString("_isGetCirculator");//抄送人
        if ((!StringUtil.isBlank(getToPerson) && "true".equals(getToPerson))
                ||(!StringUtil.isBlank(getApprover2SubFlow) && "true".equals(getApprover2SubFlow))) {
            String _flowId = params.getParameterAsString("_flowId");
            String _docId = params.getParameterAsString("_docId");
            String _nodeId = params.getParameterAsString("_nodeId");
            Collection<BaseUser> users = StateMachineHelper.getPrincipalList(
                    _docId, getUser(), _nodeId, getRequest(), _flowId);
            if (users != null && !users.isEmpty()) {
                w.append(" AND id in(");
                for (Iterator<BaseUser> iterator = users.iterator(); iterator
                        .hasNext();) {
                    BaseUser user = (BaseUser) iterator.next();
                    w.append("'").append(user.getId()).append("',");
                }
                w.setLength(w.length() - 1);
                w.append(")");
            }
        }else if(!StringUtil.isBlank(getCirculator)
                && "true".equals(getCirculator)){
            String _flowId = params.getParameterAsString("_flowId");
            String _docId = params.getParameterAsString("_docId");
            String _nodeId = params.getParameterAsString("_nodeId");
            Collection<BaseUser> users = StateMachineHelper.getCirculatorList(
                    _docId, getUser(), _nodeId, getRequest(), _flowId);
            if (users != null && !users.isEmpty()) {
                w.append(" AND id in(");
                for (Iterator<BaseUser> iterator = users.iterator(); iterator
                        .hasNext();) {
                    BaseUser user = (BaseUser) iterator.next();
                    w.append("'").append(user.getId()).append("',");
                }
                w.setLength(w.length() - 1);
                w.append(")");
            }
        }
        return w.toString();
    }*/
}
