package com.teemlink.qm.questionnaire.controller;


import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.base.controller.BaseController;
import com.teemlink.qm.base.model.Department;
import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.WebUser;
import com.teemlink.qm.config.DepartmentAPI;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcess;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcessBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

@Controller(value = "QuestionnaireAction")
@RequestMapping(value = "/qm/")
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include = JsonSerialize.Inclusion.NON_NULL)
public class QuestionnaireController extends BaseController<QuestionnaireVO> {

	@Autowired
	protected HttpServletResponse response;

	@Autowired
	protected HttpServletRequest request;

	private String s_title;
	// 10/22添加 已经完成的问卷 By toby
	protected DataPackage<QuestionnaireVO> doneDatas = null;

	public QuestionnaireController() {
		super();
		content = new QuestionnaireVO();
		process = new QuestionnaireProcessBean();
	}

	/**
	 * 问卷列表
	 *
	 * @return
	 */
	@RequestMapping(value = "questionnaire/list.action")
	public ModelAndView doList() {
		try {
			ParamsTable params = getParams();

			String s_title = params.getParameterAsString("s_title");
			if (s_title == null)
				s_title = "";

			String _currpage = params.getParameterAsString("_currpage");
			String _pagelines = params.getParameterAsString("_pagelines");

			int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
			int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines)
					: Integer.MAX_VALUE;

			setDatas(((QuestionnaireProcess) process).doQueryByFilter(s_title, page, lines, getUser()));
			setS_title(s_title);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/questionnaire/issued");
				mav.addObject("datas", datas);
				mav.addObject("s_title", s_title);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/list");
			mav.addObject("datas", datas);
			mav.addObject("s_title", s_title);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("/qm/questionnaire/list");
			return mav;
		}
	}

	/**
	 * 删除问卷
	 *
	 * @return
	 */
	@RequestMapping(value = "questionnaire/delete.action")
	public String doDelete() {
		try {
			String[] _select = get_selects();
			process.doRemove(_select);
			return "forward:/qm/questionnaire/list.action";
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}

	/**
	 * 问卷编辑
	 */
	@RequestMapping(value = "questionnaire/edit.action")
	public ModelAndView doEdit() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			setContent(process.doView(id));

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
			mav.addObject(content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 新建问卷
	 */
	@RequestMapping(value = "questionnaire/new.action")
	public ModelAndView doNew() {
		try {
			QuestionnaireVO question = ((QuestionnaireProcessBean) process).doNew();
			setContent(question);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
//				mav.addObject(content);
			mav.addObject("content",content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 保存问卷
	 */
	@RequestMapping(value = "questionnaire/save.action")
	public ModelAndView doSave() {
		try {
			QuestionnaireVO question = (QuestionnaireVO) getContent();
			WebUser user = getUser();
			if (StringUtil.isBlank(question.getCreator())) {
				question.setCreator(user.getId());
				question.setCreatorName(user.getName());
				question.setCreateDate(new Date());
				String departmentID = user.getDefaultDepartment();
				question.setCreatorDeptId(departmentID);
				String departmentName = "";
//				DepartmentProcess departmentProcess = (DepartmentProcess)ProcessFactory.createProcess(DepartmentProcess.class);
//				DepartmentVO departmentVO = (DepartmentVO)departmentProcess.doView(departmentID);
				Department departmentVO = getDepartment(departmentID);
				if (null != departmentVO)
					departmentName = departmentVO.getName();
				question.setCreatorDeptName(departmentName);
			}
			((QuestionnaireProcess) process).doSave(question);

			setContent(question);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
			mav.addObject("content",content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 再次编辑问卷
	 */
	@RequestMapping(value = "questionnaire/rebuild.action")
	public ModelAndView doRebuild() {
		try {
			QuestionnaireVO question = (QuestionnaireVO) getContent();
			WebUser user = getUser();
			if (StringUtil.isBlank(question.getCreator())) {
				question.setCreator(user.getId());
				question.setCreatorName(user.getName());
				question.setCreateDate(new Date());
				String departmentID = user.getDefaultDepartment();
				question.setCreatorDeptId(departmentID);
				String departmentName = "";
//				DepartmentProcess departmentProcess = (DepartmentProcess)ProcessFactory.createProcess(DepartmentProcess.class);
//				DepartmentVO departmentVO = (DepartmentVO)departmentProcess.doView(departmentID);
				Department departmentVO = getDepartment(departmentID);
				if (null != departmentVO)
					departmentName = departmentVO.getName();
				question.setCreatorDeptName(departmentName);
			}
			((QuestionnaireProcess) process).doReBuild(question);
			((QuestionnaireProcess) process).doSave(question);

			question.setStatus(0);
			setContent(question);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/content");
			mav.addObject(content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}

	}

	@RequestMapping(value = "questionnaire/showresult.action")
	public ModelAndView doShowResult() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			setContent(((QuestionnaireProcessBean) process).doShowResult(id, getUser()));

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("qm/questionnaire/chart");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/questionnaire/chart");
			mav.addObject(content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 发布问卷
	 *
	 * @return
	 */
	@GetMapping(value = "questionnaire/publish.action")
	public String doPublish() {
		try {
			QuestionnaireVO question = (QuestionnaireVO) getContent();
			WebUser user = getUser();
			if (StringUtil.isBlank(question.getCreator())) {
				question.setCreator(user.getId());
				question.setCreatorName(user.getName());
				question.setCreateDate(new Date());
				String departmentID = user.getDefaultDepartment();
				question.setCreatorDeptId(departmentID);
				String departmentName = "";
				Department departmentVO = getDepartment(departmentID);
				if (null != departmentVO)
					departmentName = departmentVO.getName();
				question.setCreatorDeptName(departmentName);
			}
			question.setDomainid(user.getDomainid());
			question.setStatus(1);
			question.setPublishDate(new Date());
			((QuestionnaireProcess) process).doSave(question);

			setContent(question);
			return "forward:/qm/questionnaire/list.action";
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	// 回收问卷
	@RequestMapping(value = "questionnaire/recover.action")
	public ModelAndView doRecover() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			if (id != null) {
				QuestionnaireVO question = (QuestionnaireVO) process.doView(id);
				if (question != null) {
					question.setDomainid(getUser().getDomainid());
					question.setStatus(QuestionnaireVO.STATUS_RECOVER);
					((QuestionnaireProcess) process).doSave(question);
					this.request.setAttribute("DATA", "SUCCESS");
				}
			}
			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/result");
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/result");
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 根据id发布问卷
	 *
	 * @return
	 */
	@RequestMapping(value = "questionnaire/publishforId.action")
	public ModelAndView doPublishforId() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String scope = params.getParameterAsString("scope");
			String ownerIds = params.getParameterAsString("ownerIds");
			String ownerNames = params.getParameterAsString("ownerNames");
			if (id != null) {
				QuestionnaireVO question = (QuestionnaireVO) process.doView(id);
				if (question != null) {
					question.setStatus(QuestionnaireVO.STATUS_PUBLISH);
					question.setOwnerIds(ownerIds);
					question.setOwnerNames(ownerNames);
					question.setScope(scope);
					question.setPublishDate(new Date());
					((QuestionnaireProcess) process).doSave(question);
					this.request.setAttribute("DATA", "SUCCESS");
				}
			}
			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/result");
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/result");
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			this.request.setAttribute("DATA", "ERROR");
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 获取首页待填问卷
	 *
	 * @return
	 */
	@RequestMapping(value = "answer/homepage.action")
	public ModelAndView doHomePage() {
		try {

			setDatas(((QuestionnaireProcess) process)
					.doQueryByPublish(getUser()));
			HttpServletRequest request = this.request;

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				// doList Begin
				setDoneDatas(((QuestionnaireProcess) process)
						.doQueryByPublishDone(getUser()));
				// doList End
				ModelAndView mav = new ModelAndView("/qm/answer/homepage");
				mav.addObject(doneDatas);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/amswer/homepage");
			mav.addObject(doneDatas);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}


	/**
	 * 创建新答卷
	 *
	 * @return
	 */
	@RequestMapping(value = "answer/new.action")
	public ModelAndView doNewAnswer() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			QuestionnaireVO question = (QuestionnaireVO) process.doView(id);
			AnswerVO answer = new AnswerVO();
			answer.setQuestionnaire_id(question.getId());
			answer.setTitle(question.getTitle());
			answer.setContent(question.getContent());
			answer.setQuestionnaire_id(id);

			setContent(answer);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/answer/content");
				mav.addObject(content);
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/answer/content");
			mav.addObject(content);
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/**
	 * 统计投票数
	 *
	 * @return
	 */
	@RequestMapping(value = "questionnaire/voteNumber.action")
	public ModelAndView doVoteNumber() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String holder_id = params.getParameterAsString("holder_id");
			String result = ((QuestionnaireProcessBean) process).doShowVoteNumber(id, holder_id, getUser());
			this.request.setAttribute("DATA", result);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/result");
				return mav;
			} else {*/
			ModelAndView mav = new ModelAndView("/qm/result");
			return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	public String getS_title() {
		return s_title;
	}

	public void setS_title(String s_title) {
		this.s_title = s_title;
	}

	public DataPackage<QuestionnaireVO> getDoneDatas() {
		return doneDatas;
	}

	public void setDoneDatas(DataPackage<QuestionnaireVO> doneDatas) {
		this.doneDatas = doneDatas;
	}

}
