package com.teemlink.qm.questionnaire.controller;


import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.StringUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.base.controller.BaseController;
import com.teemlink.qm.base.model.Department;
import com.teemlink.qm.base.model.WebUser;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcess;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcessBean;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletContext;
import java.io.File;
import java.util.Date;
import java.util.Map;

@Controller(value="QuestionServiceAction")
@RequestMapping(value="/qm/questionnaireservice")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class QuestionServiceController extends BaseController<QuestionnaireVO> {
	private static final Logger log = LoggerFactory.getLogger(QuestionServiceController.class);
	public QuestionServiceController() {
		super();
		content = new QuestionnaireVO();
		process = new QuestionnaireProcessBean();
	}

	/**
	 * 待填写问卷
	 * 
	 * @return
	 */
	@RequestMapping(value="/list.action")
	public Map<String, Object> doList() {
		try {
			//传入参数
			//currpage 需要获取的当前页数 默认为1
			//pagelines 页面列表大小 默认为50
			ParamsTable params = getParams();
			String title = params.getParameterAsString("title");
			if (title == null)
				title = "";
			String _currpage = params.getParameterAsString("_currpage");
			String _pagelines = params.getParameterAsString("_pagelines");

			int page = (_currpage != null && _currpage.length() > 0) ? Integer
					.parseInt(_currpage) : 1;
			int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer
					.parseInt(_pagelines) : 50;
			DataPackage<QuestionnaireVO> dataPackage = ((QuestionnaireProcess) process)
					.doQueryMyPartake(title, AnswerVO.STATUS_FILLING, page, lines, getUser());

			return addActionResult(true, "", dataPackage);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 删除问卷
	 * 
	 * @return
	 */
	@RequestMapping(value="/delete.action")
	public Map<String, Object> doDelete() {
		try {
			ParamsTable params = getParams();
			String[] _select = params.getParameterAsArray("_select");
			process.doRemove(_select);
			return addActionResult(true, "", null);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 问卷编辑
	 */
	@RequestMapping(value="/edit.action")
	public Map<String, Object> doEdit() {
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		try {
			QuestionnaireVO vo = (QuestionnaireVO) process.doView(id);
			if (vo == null)
				throw new Exception("找不到记录");
			return addActionResult(true, "", vo);
		} catch (Exception e) {
			//System.out.println(e.getMessage());
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/showResult.action")
	public Map<String, Object> doShowResult() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			QuestionnaireVO vo = ((QuestionnaireProcessBean) process).doShowResult(id,
					getUser());
			return addActionResult(true, "", vo);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 获取报表数据
	 * @return
	 */
	@RequestMapping(value="/reportform.action")
	public Map<String, Object> doReportForm() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			QuestionnaireVO vo = ((QuestionnaireProcessBean) process).showReportForm(id);
			return addActionResult(true, "", vo);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 发布问卷
	 * 
	 * @return
	 */
	@RequestMapping(value="/publish.action")
	public Map<String, Object> doPublish() {
		try {
			QuestionnaireVO question = (QuestionnaireVO) getContent();
			WebUser user = getUser();
			if (StringUtil.isBlank(question.getCreator())) {
				question.setCreator(user.getId());
				question.setCreatorName(user.getName());
				question.setCreateDate(new Date());
				String departmentID = user.getDefaultDepartment();
				question.setCreatorDeptId(departmentID);
				String departmentName = "";
//				DepartmentProcess departmentProcess = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
//				DepartmentVO departmentVO = (DepartmentVO)departmentProcess.doView(departmentID);
				Department departmentVO =getDepartment(departmentID);
				if(null!=departmentVO)
				    departmentName = departmentVO.getName();
				question.setCreatorDeptName(departmentName);
			}
			question.setDomainid(user.getDomainid());
			question.setStatus(1);
			question.setPublishDate(new Date());
			((QuestionnaireProcess) process).doSave(question);
			
			return addActionResult(true, "", question);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}


	/**
	 * 保存问卷
	 */
	@RequestMapping(value="/save.action")
	public Map<String, Object> doSave() {
		try {
			QuestionnaireVO question = (QuestionnaireVO) getContent();
			WebUser user = getUser();
			if (StringUtil.isBlank(question.getCreator())) {
				question.setCreator(user.getId());
				question.setCreatorName(user.getName());
				question.setCreateDate(new Date());
				String departmentID = user.getDefaultDepartment();
				question.setCreatorDeptId(departmentID);
				String departmentName = "";
//				DepartmentProcess departmentProcess = (DepartmentProcess)ProcessFactory.createProcess(DepartmentProcess.class);
//				DepartmentVO departmentVO = (DepartmentVO)departmentProcess.doView(departmentID);
				Department departmentVO = getDepartment(departmentID);
				if(null!=departmentVO)
				    departmentName = departmentVO.getName();
				question.setCreatorDeptName(departmentName);
			}
			question = (QuestionnaireVO) ((QuestionnaireProcess) process).doSave(question);

			return addActionResult(true, "", question);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 统计投票数
	 * 
	 * @return
	 */
	@RequestMapping(value="/voteNumber.action")
	public Map<String, Object> doVoteNumber() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String holder_id = params.getParameterAsString("holder_id");
			String result = ((QuestionnaireProcessBean) process)
					.doShowVoteNumber(id, holder_id, getUser());

			return addActionResult(true, "", result);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 问卷中心页面
	 * 
	 * @return
	 */
	@RequestMapping(value="/center.action")
	public Map<String, Object> questionnairCenter() {
		try {
			// 传入参数
			// title 需要搜索的标题
			// type 值为0或1 0代表 我发布的问卷 1代表我参与的问卷
			// currpage 需要获取的当前页数 默认为1
			// pagelines 页面列表大小 默认为50
			// status 问卷分类参数，
			// ------当type为我发布的问卷时
			// ---------status==0代表草稿 ==1代表已发布 ==2代表已回收
			// ------当type为我参与的问卷时
			// ---------status==1代表待填写的问卷 ==2代表已填写的问卷
			ParamsTable params = getParams();
			String title = params.getParameterAsString("title");
			if (title == null)
				title = "";
			String _type = params.getParameterAsString("type");
			String _currpage = params.getParameterAsString("_currpage");
			String _pagelines = params.getParameterAsString("_pagelines");
			String _status = params.getParameterAsString("status");

			int type = QuestionnaireVO.TYPE_PUBLISH;
			if (!StringUtil.isBlank(_type)) {
				type = Integer.parseInt(_type);
			}
			int page = (_currpage != null && _currpage.length() > 0) ? Integer
					.parseInt(_currpage) : 1;
			int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer
					.parseInt(_pagelines) : 50;

			int status = QuestionnaireVO.STATUS_ALL;
			if (!StringUtil.isBlank(_status)) {
				status = Integer.parseInt(_status);
			}

			DataPackage<QuestionnaireVO> dataPackage = null;
			
			if (QuestionnaireVO.TYPE_PUBLISH == type) {
				dataPackage = ((QuestionnaireProcess) process)
						.doQueryMyPublish(title, status, page, lines, getUser());
			} else if (QuestionnaireVO.TYPE_PARTAKE == type) {
				dataPackage = ((QuestionnaireProcess) process)
						.doQueryMyPartake(title, status, page, lines, getUser());
			} else {
				throw new Exception("必须传入正确的参数type");
			}
			return addActionResult(true, null, dataPackage);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 回收问卷
	 * @return
	 */
	@RequestMapping(value="/recover.action")
	public Map<String, Object> doRecover() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			if (id != null) {
				QuestionnaireVO question = (QuestionnaireVO) process.doView(id);
				if (question != null) {
					question.setDomainid(getUser().getDomainid());
					question.setStatus(QuestionnaireVO.STATUS_RECOVER);
					((QuestionnaireProcess) process).doSave(question);
				}
			}
			return addActionResult(true, null, null);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
    /**
     * 根据附近url删除对应的图片
     * 
     * @return
     */
	@RequestMapping(value="/deleteAttachment.action")
    public Map<String, Object> doDeleteAttachment() {
	try {
	    ParamsTable params = getParams();
	    String url = params.getParameterAsString("url");

	    // 服务器目录的绝对路径
	    WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();  
        ServletContext servletContext = webApplicationContext.getServletContext();
	    String realPath = servletContext.getRealPath("");

	    // 存放此文件的绝对路径
	    String savePath = realPath + url;
	    
	    //调查问卷的存储目录
	    String uploadPath = DefaultProperty.getProperty("myapps.qm.upload.path","/uploads/qm/");
	    if(!savePath.contains(uploadPath)){
		throw new Exception("非法的文件路径");
	    }
	    File file = new File(savePath);
	    
	    // 删除文件
	    file.delete();

	    return addActionResult(true, null, "");
	} catch (Exception e) {
	    log.error(e.getMessage());
	    if (!(e instanceof OBPMValidateException)) {
			e.printStackTrace();
		    }
	    return addActionResult(false, e.getMessage(), null);
	}
  }
}
