package com.teemlink.qm.notification;

import cn.myapps.common.exception.OBPMValidateException;
import com.teemlink.qm.base.model.Domain;
import com.teemlink.qm.base.model.User;
import com.teemlink.qm.util.CLoader;
import net.sf.json.JSONObject;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * 微信服务接口代理
 * @author Happy
 *
 */
public class WeixinServiceProxy {

	/**
	 * 发送图文消息
	 * @param touser
	 * 		用户账号列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送
	 * @param title
	 * 		消息标题
	 * @param description
	 * 		消息描述
	 * @param url
	 * 		消息url
	 * @param picUrl
	 * 		图片url
	 * @param domainId
	 * 		企业域id
	 * @param applicationid
	 * 		发送目标软件id（null 表示发送到企业小助手）
	 * @return
	 * @throws Exception
	 */
	public static boolean sendRichTextMessage(String touser,String title,String description,String url,String picUrl,String domainId,String applicationid)  throws Exception{
		return (Boolean) invoke("sendRichTextMessage", new Object[]{touser,title,description,url,picUrl,domainId,applicationid});
	}

	/**
	 * 发送文本消息
	 * @param touser
	 * 		用户账号列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送
	 * @param content
	 * 		消息内容
	 * @param domainId
	 * 		企业域id
	 * @param applicationid
	 * 		发送目标软件id（null 表示发送到企业小助手）
	 * @return
	 * @throws Exception
	 */
	public static boolean sendTextMessage(String touser,String content,String domainId,String applicationid)  throws Exception{
		return (Boolean) invoke("sendTextMessage", new Object[]{touser,content,domainId,applicationid});
	}

	private static Object invoke(String methodName, Object[] args) throws Exception {
		try{
			Class<?> ownerClass = CLoader.initWeixinService();
			Class<?>[] argsClass = new Class[args.length];

			for (int i = 0, j = args.length; i < j; i++) {
				argsClass[i] = args[i].getClass();
			}

			Method method = ownerClass.getMethod(methodName, argsClass);
			return method.invoke(null, args);
		}catch (InvocationTargetException e) {
			Throwable t = e.getTargetException();
			if(t instanceof OBPMValidateException){
				throw (OBPMValidateException)t;
			}else{
				throw new OBPMValidateException(t.getLocalizedMessage(),t);
			}
		}catch (Exception e) {
			throw e;
		}
	}
}
