package com.teemlink.qm.notification;

import cn.myapps.common.Environment;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.base.model.Domain;
import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.User;
import com.teemlink.qm.config.DomainAPI;
import com.teemlink.qm.config.UserAPI;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcess;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcessBean;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * qm微信端消息提醒实现类
 * @author ahan
 *
 */
public class QuestionnaireNotificationServiceImpl implements QuestionnaireNotificationService{

	/**
	 * 微OA365反向代理模式外网访问地址
	 */
	private static final String weioa365_addr = "https://yun.weioa365.com/{site_id}";
	private static final String qm_app_id = "12";
	
	QuestionnaireProcess questionnaireProcess = new QuestionnaireProcessBean();

	@Override
	public void completeAnswer(AnswerVO answer) throws Exception {
		Domain domain = getDomain(answer.getDomainid());

		if(domain==null) return;
		if(Domain.WEIXIN_PROXY_TYPE_NONE.equals(domain.getWeixinProxyType())) return;

		QuestionnaireVO questionnaire = (QuestionnaireVO) questionnaireProcess.doView(answer.getQuestionnaire_id());

//		UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//		UserVO userVO = (UserVO) userProcess.doView(questionnaire.getCreator());
		UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
		ResultWarp<User> userResultWarp = userAPI.getUserById(questionnaire.getCreator());
		User user = userResultWarp.getData();
		
		String touser = user.getLoginno();
		String title = "[提醒]"+questionnaire.getTitle();
		
		String desc = "您发布的问卷所有参与人都已完成填写。";
		String url = getShowUrl(questionnaire.getId(),domain);
		NotificationUtil.sendRichWeixinMessage(touser,title , desc, url, "", domain.getId(), qm_app_id);
	}
	
	@Override
	public void completeQuestionnaire(QuestionnaireVO questionnaire) throws Exception {
		Domain domain = getDomain(questionnaire.getDomainid());
		if(domain==null) return;
		if(Domain.WEIXIN_PROXY_TYPE_NONE.equals(domain.getWeixinProxyType())) return;

//		UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//		UserVO userVO = null;
		UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);

		String actorIds = questionnaire.getActorIds();
		StringBuffer actorIdsBuffer = new StringBuffer();
		for(String actorId: actorIds.split(";")){
			if(StringUtil.isBlank(actorId))
				continue;
			ResultWarp<User> userResultWarp = userAPI.getUserById(questionnaire.getCreator());
			User user = userResultWarp.getData();
			if(user.getLoginno()!=null)
			actorIdsBuffer.append(user.getLoginno()).append("|");
		}
		String touser_ = actorIdsBuffer.toString();
		String touser = touser_.substring(0,touser_.length()-1);

		String title = questionnaire.getTitle();
		String content = "您填写的问卷 [" + title + "] 已成功回收，感谢您的积极参与！";
		NotificationUtil.sendTextWeixinMessage(touser, content, domain.getId(), qm_app_id);
	}

	@Override
	public void publish(QuestionnaireVO questionnaire) throws Exception {
		Domain domain = getDomain(questionnaire.getDomainid());
		if(domain==null) return;
		if(Domain.WEIXIN_PROXY_TYPE_NONE.equals(domain.getWeixinProxyType())) return;
		
//		UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//		UserVO userVO = null;

		UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
		String actorIds = questionnaire.getActorIds();
		StringBuffer actorIdsBuffer = new StringBuffer();
		for(String actorId: actorIds.split(";")){
			if(StringUtil.isBlank(actorId))
				continue;
			ResultWarp<User> userResultWarp = userAPI.getUserById(questionnaire.getCreator());
			User user = userResultWarp.getData();
			if(user.getLoginno()!=null)
			actorIdsBuffer.append(user.getLoginno()).append("|");
		}
		
		String touser_ = actorIdsBuffer.toString();
		String touser = touser_.substring(0,touser_.length()-1);
		
		String title = "[待办]"+questionnaire.getTitle();
		String desc = questionnaire.getCreatorName()+"邀请你参加问卷调查。";
		String url = getWriteUrl(questionnaire.getId(),domain);
		NotificationUtil.sendRichWeixinMessage(touser,title , desc, url, "", domain.getId(), qm_app_id);
	}
	
	/**
	 * 获取待填写问卷详情URL地址
	 * @param questionnaireId 问卷Id
	 * @param user 当前用户
	 * @param domain 当前企业域
	 * @return
	 */
	private String getWriteUrl(String questionnaireId,Domain domain){
		StringBuilder url = new StringBuilder();
        if (Domain.WEIXIN_PROXY_TYPE_LOCAL.equals(domain.getWeixinProxyType())
                || Domain.WEIXIN_PROXY_TYPE_ENTERPRISE_WECHAT.equals(domain.getWeixinProxyType())) {
            try {
                String redirect_uri = URLEncoder.encode(domain.getServerHost() + "/qm/wap/center.jsp?application=qm&active=qm-write&id=" + questionnaireId, "utf-8");
                url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=")
                .append(domain.getWeixinCorpID())
                .append("&redirect_uri=").append(redirect_uri)
                .append("&response_type=code&scope=snsapi_base&state=").append(domain.getId())
                .append("#wechat_redirect");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

		}else if(Domain.WEIXIN_PROXY_TYPE_CLOUD.equals(domain.getWeixinProxyType())){//云端代理模式
			try {
				String redirect_uri = URLEncoder.encode(weioa365_addr.replace("{site_id}", Environment.getMACAddress())+"/qm/wap/center.jsp?active=qm-write&id="+questionnaireId,"utf-8");
				url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=")
				.append("(appid)")
				.append("&redirect_uri=").append(redirect_uri)
				.append("&response_type=code&scope=snsapi_base&state=").append(domain.getId())
				.append("#wechat_redirect");
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}
		return url.toString();
	}
	
	/**
	 * 获取问卷详情URL地址
	 * @param questionnaireId 问卷Id
	 * @param user 当前用户
	 * @param domain 当前企业域
	 * @return
	 */
	private String getShowUrl(String questionnaireId, Domain domain){
		StringBuilder url = new StringBuilder();
        if (Domain.WEIXIN_PROXY_TYPE_LOCAL.equals(domain.getWeixinProxyType())
                || Domain.WEIXIN_PROXY_TYPE_ENTERPRISE_WECHAT.equals(domain.getWeixinProxyType())) {
            try {
                String redirect_uri = URLEncoder.encode(domain.getServerHost() + "/qm/wap/center.jsp?application=qm&active=qm-show&id=" + questionnaireId, "utf-8");
                url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=")
                .append(domain.getWeixinCorpID())
                .append("&redirect_uri=").append(redirect_uri)
                .append("&response_type=code&scope=snsapi_base&state=").append(domain.getId())
                .append("#wechat_redirect");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
			
		}else if(Domain.WEIXIN_PROXY_TYPE_CLOUD.equals(domain.getWeixinProxyType())){//云端代理模式
			try {
				String redirect_uri = URLEncoder.encode(weioa365_addr.replace("{site_id}", Environment.getMACAddress())+"/qm/wap/center.jsp?active=qm-show&id="+questionnaireId,"utf-8");
				url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=")
				.append("(appid)")
				.append("&redirect_uri=").append(redirect_uri)
				.append("&response_type=code&scope=snsapi_base&state=").append(domain.getId())
				.append("#wechat_redirect");
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}
		return url.toString();
	}

	/**
	 * 获取企业域
	 * @param domainId
	 * @return
	 */
	private Domain getDomain(String domainId){
		try {
			DomainAPI domainAPI = SpringApplicationContextUtil.getBean(DomainAPI.class);
			ResultWarp<Domain> resultWarp = domainAPI.getDomainById(domainId);
			Domain domain = resultWarp.getData();
			
			return domain;
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
		
	}

}
