package com.teemlink.qm.config;

import cn.myapps.common.data.DataPackage;
import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.User;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface UserAPI {

    @GetMapping(value = "/api/authtime/user/{id}")
    ResultWarp<User> getUserById(@PathVariable String id) throws Exception;

    @PostMapping(value = "/api/authtime/domain/{domainid}/users")
    ResultWarp<DataPackage<User>> queryUsers(@PathVariable String domainid, @RequestBody Map map) throws Exception;

    @GetMapping(value = "/api/authtime/department/{departmentid}/users")
    ResultWarp<DataPackage<User>> getDepartmentUsers(@PathVariable String departmentid
            ,@RequestParam String currpage,@RequestParam String pagelines) throws Exception;
}
