package com.teemlink.qm.config;

import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.Role;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;


@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface RoleAPI {

    @GetMapping(value = "/api/authime/application/{applicationid}/roles?currpage=1& pagelines=90000")
    ResultWarp<List<Role>> queryByAppid(@PathVariable String applicationid) throws Exception;

}
