package com.teemlink.qm.config;

import com.teemlink.qm.base.schema.SchemaHelper;
import com.teemlink.qm.init.InitInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class QmsStartListener implements ApplicationListener<ContextRefreshedEvent> {

    private static final Logger logger = LoggerFactory.getLogger(QmsStartListener.class);

    @Override
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        logger.error("初始化开始");
        long start = System.currentTimeMillis();
        try{
            SchemaHelper.getInstance().init();
            logger.error("init table");
        } catch(Exception e){
            logger.error("init table error");
            e.printStackTrace();
        }

        try {
            InitInstance.init();
            logger.error("init application");
        } catch (Exception e) {
            logger.error("init application error");
            e.printStackTrace();
        }
        logger.error("初始化结束，用时：" + (System.currentTimeMillis() - start) + " ms.");
    }
}
