package com.teemlink.qm.config;

import cn.myapps.common.util.PropertyUtil;
import com.teemlink.qm.base.web.interceptor.ActionInterceptor;
import com.teemlink.qm.questionnaire.action.QuestionUploadServlet;
import com.teemlink.qm.util.PersistenceHandlerInterceptor;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

@Configuration
public class QmsMvcConfig  extends WebMvcConfigurerAdapter {

/*    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/admin");
        registry.setOrder(Ordered.HIGHEST_PRECEDENCE);
        super.addViewControllers(registry);
    }*/

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        System.err.println("good girl, this is MyappsMvcConfig.java =====AAA");

        //旧的action拦截器，要删掉，好像还有message在用
        registry.addInterceptor(new ActionInterceptor()).addPathPatterns("/**/*.action")
                .excludePathPatterns("/static/**");
        //DAO资源清理拦截器,关闭数据库连接等
        registry.addInterceptor(new PersistenceHandlerInterceptor()).addPathPatterns("/**")
                .excludePathPatterns("/static/**");

    }

    @Override//全局统一异常处理
    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        resolvers.add(new CommonsExceptionResolver());
    }

    @Bean // FileDownloadServlet 文件下载
    public ServletRegistrationBean getOfficeUploadServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean(new QuestionUploadServlet());
        bean.addUrlMappings("/qm/servlet/upload"); // 访问路径值
        return bean;
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
//        registry.addResourceHandler("/**").addResourceLocations("classpath:/static/").addResourceLocations("/");
        String  uploadsFolderPath  =  PropertyUtil.getPath()+"/uploads/";
        System.out.println("==uploadsFolderPath:" + uploadsFolderPath );
        registry.addResourceHandler("/uploads/**").addResourceLocations("file:" + uploadsFolderPath );
        super.addResourceHandlers(registry);
    }

    @Bean
    public QmsStartListener applicationStartListener() {
        return new QmsStartListener();
    }
}
