package com.teemlink.qm.config;

import com.teemlink.qm.base.model.Domain;
import com.teemlink.qm.base.model.ResultWarp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.Collection;

@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface DomainAPI {

    @GetMapping(value = "/api/authtime/domain/{id}")
    ResultWarp<Domain> getDomainById(@PathVariable String id) throws Exception;

    //有问题，晚点补--Jarod
    @GetMapping(value = "/api/authtime/domain/{domainName}")
    ResultWarp<Domain> findDomainByName(@PathVariable String domainName);

    //有问题，晚点补--Jarod
    @GetMapping(value = "/api/authtime/domain/{status}")
    ResultWarp<Collection<Domain>> findDomainsByStatus(@PathVariable int status);

}
