package com.teemlink.qm.config;

import cn.myapps.common.data.DataPackage;
import com.teemlink.qm.base.model.Department;
import com.teemlink.qm.base.model.ResultWarp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface DepartmentAPI {

    @GetMapping(value = "/api/authtime//department/{id}")
    ResultWarp<Department> getDepartmentById(@PathVariable(required = false, value="id") String id);

    @GetMapping(value = "/api/authtime/domain/{domainid}/department/root")
    ResultWarp<Department> getRootDepartments(@PathVariable String domainid);

    @GetMapping(value = "/api/authtime/domain/{domainid}/departments")
    ResultWarp<DataPackage<Department>> getDepartments(@PathVariable String domainid, @RequestBody Map content
            , @RequestParam String currpage, @RequestParam String pagelines);

    @GetMapping(value = "/api/authtime/domain/{domainid}/department/{departmentid}/subdepartments")
    ResultWarp<List<Department>> getSubDepartments(@PathVariable String domainid, @PathVariable String departmentid);
}
