package com.teemlink.qm.config;

import cn.myapps.common.util.StringUtil;
import com.teemlink.qm.util.ConnectionManager;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

public class CommonsExceptionResolver implements HandlerExceptionResolver {

    private static final Logger log = LoggerFactory.getLogger(CommonsExceptionResolver.class);

    @Override
    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        try {
            log.error("异常信息", e);
            ConnectionManager.closeConnection();

            httpServletResponse.setContentType("text/json;charset=utf-8");
            httpServletResponse.resetBuffer();
            httpServletResponse.setStatus(500);

            PrintWriter writer = httpServletResponse.getWriter();
            JSONObject json = new JSONObject();
            json.put("errcode", 500);
            if(StringUtil.isBlank(e.getMessage())){
                json.put("errmsg", "系统异常，请联系管理员！");
            } else {
                json.put("errmsg", e.getMessage());
            }
            writer.print(json);
        } catch (Exception ex){
            log.error("异常信息", ex);
        }
        return null;
    }
}
