package com.teemlink.qm.config;

import cn.myapps.common.data.DataPackage;
import com.teemlink.qm.base.model.Application;
import com.teemlink.qm.base.model.ResultWarp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface ApplicationAPI {

    @GetMapping(value = "/api/authime/applications")
    ResultWarp<List<Application>> queryAll() throws Exception;

    @PostMapping(value = "/api/authtime/domain/{domainid}/applications/bind")
    ResultWarp<DataPackage<Application>> queryAppByDomainid(@PathVariable String domainid, @RequestBody Map map);
}
