package com.teemlink.qm.base.web.support;

import com.teemlink.qm.base.model.JSR303;
import com.teemlink.qm.util.JSR303Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 验证Action中属性支持类
 * Created by ZhanBo-ZJB on 2017/10/22.
 */
public class ValidateSupport implements DataTransportationSupport<Map<String,Set<String>>,Object> {
    private static final Logger log = LoggerFactory.getLogger(ValidateSupport.class);
    public void handle(Map<String,Set<String>> ValidateObjectNames, Object target) {
        List<String> errorMessage = new ArrayList<String>();

        try {
            for(Map.Entry<String,Set<String>> entry :ValidateObjectNames.entrySet()) {

                //获取对象属性
                Field objField = getField(target.getClass(),entry.getKey());
                objField.setAccessible(true);

                //需要验证
                Object validateObj = objField.get(target);

                //判断对象是否需要验证
                if(validateObj != null && validateObj.getClass().getAnnotation(JSR303.class) != null) {

                    errorMessage.addAll(JSR303Util.check(validateObj,entry.getValue()));
                }

                //注入错误信息
                Method setErrorMessageMethod = target.getClass().getMethod("setValidateMessage",List.class);

                setErrorMessageMethod.invoke(target,errorMessage);

            }
        }catch (Exception e) {
            log.debug("参数验证错误! "+e.getMessage());
        }
    }



    /**
     * 通过属性名称获取class对象的属性对象(通过回调的方式到父类中寻找属性)
     * @param
     * @return
     */
    private Field getField(Class clazz, String name ){

        Field field = null;

        try{
            field = clazz.getDeclaredField(name);

        }catch (Exception e){
            field = getField(clazz.getSuperclass(),name);

        }

        field.setAccessible(true);
        return field;

    }

}
