package com.teemlink.qm.base.web.support;

import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;

/**
 * set方法调用支持类
 * Created by ZhanBo-ZJB on 2017/10/28.
 */
public class SetMethodInvokeSupport implements DataTransportationSupport<HttpServletRequest,Object>{

    protected static final Logger LOG = LoggerFactory.getLogger(SetMethodInvokeSupport.class);

    /**
     * 首字母大写
     * @param name
     * @return
     */
    private String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return  name;
    }

    /**
     * 获取所有方法
     * @param clazz
     * @return
     */
    public Method[] getAllMethods(Class clazz) {

        Method[] methods = clazz.getDeclaredMethods();

        if(clazz.getSuperclass() != null) {
            Method[] superClassMethods = getAllMethods(clazz.getSuperclass());

            methods = getMergeArray(methods,superClassMethods);
        }

        return  methods;
    }

    /**
     * 通过参数名称获取set方法名称
     * @param name
     */
    private String getMethodName(String name) {
        return "set"+captureName(name);
    }

    @Override
    public void handle(HttpServletRequest dataSource, Object target) {
        //获取所有参数的名称
        Enumeration<String> enumeration = dataSource.getParameterNames();

        while(enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();

            String value = dataSource.getParameter(name);

            String[] array = dataSource.getParameterValues(name);

            //获取set方法名称
            String setMethodName = getMethodName(name);

            for(Method method:getAllMethods(target.getClass())) {
                if(method.getName().equals(setMethodName)) {
                    Class<?>[] types = method.getParameterTypes();
                    if(types.length == 1) {
                        try {
                            if(types[0].isArray()) {
                                method.invoke(target, ConvertUtils.convert(array,types[0]));
                            }else {
                                method.invoke(target, ConvertUtils.convert(value,types[0]));
                            }
                        }catch (InvocationTargetException e) {
                            LOG.debug("{}", e.getMessage());
                        } catch (Exception e) {
                            //LOG.debug("{}", setMethodName+"方法调用失败!");
                        }
                    }
                }
            }

        }
    }

    /**
     * 合并数组
     */
    public Method[] getMergeArray(Method[] al, Method[] bl) {
        Method[] a = al;
        Method[] b = bl;
        Method[] c = new Method[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

}
