package com.teemlink.qm.base.web.support;

import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 * request参数映射至ModelAndView支持类
 * Created by ZhanBo-ZJB on 2017/10/25.
 */
public class MapParamsToModelAndView implements DataTransportationSupport<HttpServletRequest,ModelAndView> {

    @Override
    public void handle(HttpServletRequest dataSource, ModelAndView target) {

        Enumeration<String> enumeration = dataSource.getParameterNames();

        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();

            String value = dataSource.getParameter(name);

            if(StringUtils.isNotBlank(value) && target.getModel().get(name) == null) {
                target.addObject(name,value);
            }
        }

    }
}
